/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelbutcher<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"modelbutcher"), "main");
    public final ModelPart left_arm;
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart right_arm;
    public final ModelPart right_leg;
    public final ModelPart left_leg;

    public Modelbutcher(ModelPart root) {
        this.left_arm = root.getChild("left_arm");
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.right_arm = root.getChild("right_arm");
        this.right_leg = root.getChild("right_leg");
        this.left_leg = root.getChild("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.offset((float)9.0f, (float)-16.0f, (float)0.0f));
        PartDefinition larm = left_arm.addOrReplaceChild("larm", CubeListBuilder.create(), PartPose.offset((float)-9.0f, (float)40.0f, (float)0.0f));
        PartDefinition left_arm_1_r1 = larm.addOrReplaceChild("left_arm_1_r1", CubeListBuilder.create().texOffs(57, 50).addBox(1.0f, -3.0f, -3.0f, 6.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.0f, (float)-40.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        PartDefinition larm2 = left_arm.addOrReplaceChild("larm2", CubeListBuilder.create().texOffs(56, 48).addBox(1.0f, -3.0f, -3.0f, 6.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)13.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(48, 52).addBox(-8.0f, -30.0f, -4.0f, 16.0f, 11.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(34, 44).addBox(-9.0f, -42.0f, -7.0f, 18.0f, 12.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -6.0f, -7.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-16.0f, (float)-6.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.offset((float)-9.0f, (float)-17.0f, (float)0.0f));
        PartDefinition rarm1 = right_arm.addOrReplaceChild("rarm1", CubeListBuilder.create(), PartPose.offset((float)9.0f, (float)41.0f, (float)0.0f));
        PartDefinition right_arm_r1 = rarm1.addOrReplaceChild("right_arm_r1", CubeListBuilder.create().texOffs(47, 0).addBox(-8.0f, -6.0f, -3.0f, 5.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(56, 43).addBox(-9.0f, -4.0f, -4.0f, 7.0f, 19.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.0f, (float)-39.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition rarm2 = right_arm.addOrReplaceChild("rarm2", CubeListBuilder.create().texOffs(51, 42).addBox(-4.0f, -2.0f, -4.0f, 7.0f, 19.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 52).addBox(-1.0f, -2.0f, -12.0f, 0.0f, 19.0f, 25.0f, new CubeDeformation(0.001f)), PartPose.offsetAndRotation((float)-7.0f, (float)16.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(72, 0).addBox(-2.0f, 8.0f, -3.0f, 6.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(63, 58).addBox(-1.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)5.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(72, 0).addBox(-4.0f, 7.0f, -3.0f, 6.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(63, 55).addBox(-3.0f, -1.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)6.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)96, (int)96);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int rgb) {
        this.left_arm.render(poseStack, buffer, packedLight, packedOverlay);
        this.body.render(poseStack, buffer, packedLight, packedOverlay);
        this.head.render(poseStack, buffer, packedLight, packedOverlay);
        this.right_arm.render(poseStack, buffer, packedLight, packedOverlay);
        this.right_leg.render(poseStack, buffer, packedLight, packedOverlay);
        this.left_leg.render(poseStack, buffer, packedLight, packedOverlay);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.right_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.left_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

