/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.entity;

import net.eternal_tales.procedures.ArkemerGravityPlatformOnEntityTickUpdateProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class ArkemerGravityPlatformEntity
extends PathfinderMob {
    public static final EntityDataAccessor<Integer> DATA_start_x = SynchedEntityData.defineId(ArkemerGravityPlatformEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_start_y = SynchedEntityData.defineId(ArkemerGravityPlatformEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_start_z = SynchedEntityData.defineId(ArkemerGravityPlatformEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_finish_x = SynchedEntityData.defineId(ArkemerGravityPlatformEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_finish_y = SynchedEntityData.defineId(ArkemerGravityPlatformEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_finish_z = SynchedEntityData.defineId(ArkemerGravityPlatformEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_mode = SynchedEntityData.defineId(ArkemerGravityPlatformEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> DATA_movement = SynchedEntityData.defineId(ArkemerGravityPlatformEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> DATA_active = SynchedEntityData.defineId(ArkemerGravityPlatformEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public ArkemerGravityPlatformEntity(EntityType<ArkemerGravityPlatformEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_start_x, (Object)0);
        builder.define(DATA_start_y, (Object)0);
        builder.define(DATA_start_z, (Object)0);
        builder.define(DATA_finish_x, (Object)0);
        builder.define(DATA_finish_y, (Object)0);
        builder.define(DATA_finish_z, (Object)0);
        builder.define(DATA_mode, (Object)"horizontal");
        builder.define(DATA_movement, (Object)"start");
        builder.define(DATA_active, (Object)false);
    }

    protected PathNavigation createNavigation(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public boolean causeFallDamage(float l, float d, DamageSource source) {
        return false;
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof AbstractArrow) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof Player) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof ThrownPotion || damagesource.getDirectEntity() instanceof AreaEffectCloud || damagesource.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.LIGHTNING_BOLT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.EXPLOSION) || damagesource.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        if (damagesource.is(DamageTypes.TRIDENT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALLING_ANVIL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (damagesource.is(DamageTypes.WITHER) || damagesource.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Datastart_x", ((Integer)this.entityData.get(DATA_start_x)).intValue());
        compound.putInt("Datastart_y", ((Integer)this.entityData.get(DATA_start_y)).intValue());
        compound.putInt("Datastart_z", ((Integer)this.entityData.get(DATA_start_z)).intValue());
        compound.putInt("Datafinish_x", ((Integer)this.entityData.get(DATA_finish_x)).intValue());
        compound.putInt("Datafinish_y", ((Integer)this.entityData.get(DATA_finish_y)).intValue());
        compound.putInt("Datafinish_z", ((Integer)this.entityData.get(DATA_finish_z)).intValue());
        compound.putString("Datamode", (String)this.entityData.get(DATA_mode));
        compound.putString("Datamovement", (String)this.entityData.get(DATA_movement));
        compound.putBoolean("Dataactive", ((Boolean)this.entityData.get(DATA_active)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datastart_x")) {
            this.entityData.set(DATA_start_x, (Object)compound.getInt("Datastart_x"));
        }
        if (compound.contains("Datastart_y")) {
            this.entityData.set(DATA_start_y, (Object)compound.getInt("Datastart_y"));
        }
        if (compound.contains("Datastart_z")) {
            this.entityData.set(DATA_start_z, (Object)compound.getInt("Datastart_z"));
        }
        if (compound.contains("Datafinish_x")) {
            this.entityData.set(DATA_finish_x, (Object)compound.getInt("Datafinish_x"));
        }
        if (compound.contains("Datafinish_y")) {
            this.entityData.set(DATA_finish_y, (Object)compound.getInt("Datafinish_y"));
        }
        if (compound.contains("Datafinish_z")) {
            this.entityData.set(DATA_finish_z, (Object)compound.getInt("Datafinish_z"));
        }
        if (compound.contains("Datamode")) {
            this.entityData.set(DATA_mode, (Object)compound.getString("Datamode"));
        }
        if (compound.contains("Datamovement")) {
            this.entityData.set(DATA_movement, (Object)compound.getString("Datamovement"));
        }
        if (compound.contains("Dataactive")) {
            this.entityData.set(DATA_active, (Object)compound.getBoolean("Dataactive"));
        }
    }

    public void baseTick() {
        super.baseTick();
        ArkemerGravityPlatformOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public boolean canCollideWith(Entity entity) {
        return true;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.FLYING_SPEED, 0.3);
        return builder;
    }
}

