/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg;

import dev.tauri.jsg.Constants;
import dev.tauri.jsg.advancements.JSGAdvancements;
import dev.tauri.jsg.api.JSGAddon;
import dev.tauri.jsg.api.JSGApi;
import dev.tauri.jsg.api.LoggerWrapper;
import dev.tauri.jsg.api.client.LoadersHolder;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.item.NotebookPageSerialization;
import dev.tauri.jsg.api.stargate.StargateSizeEnum;
import dev.tauri.jsg.api.stargate.network.IStargateNetwork;
import dev.tauri.jsg.command.JSGCommands;
import dev.tauri.jsg.config.data.ProgressJSON;
import dev.tauri.jsg.config.stargate.StargateDimensionConfig;
import dev.tauri.jsg.config.stargate.StargateRIGConfig;
import dev.tauri.jsg.integration.InternalIntegrations;
import dev.tauri.jsg.integration.cctweaked.CCIntegrationWrapper;
import dev.tauri.jsg.integration.oc2.OCIntegrationWrapper;
import dev.tauri.jsg.integration.oculus.OculusAPIWrapper;
import dev.tauri.jsg.item.linkable.dialer.modes.UniverseDialerModes;
import dev.tauri.jsg.loader.model.ModelLoader;
import dev.tauri.jsg.loader.texture.TextureLoader;
import dev.tauri.jsg.model.JSGBlockModel;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.recipes.NotebookRecipe;
import dev.tauri.jsg.recipes.PageAndUniverseDialerRecipe;
import dev.tauri.jsg.recipes.StargateOrlinBaseBlockRecipe;
import dev.tauri.jsg.recipes.UniverseDialerCloneRecipe;
import dev.tauri.jsg.registry.BlockEntityRegistry;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.registry.EntityRegistry;
import dev.tauri.jsg.registry.FluidRegistry;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.registry.MenuTypeRegistry;
import dev.tauri.jsg.registry.RaycastersRegistry;
import dev.tauri.jsg.registry.SoundRegistry;
import dev.tauri.jsg.registry.TabRegistry;
import dev.tauri.jsg.registry.VillagerRegistry;
import dev.tauri.jsg.registry.structure.FeatureRegistry;
import dev.tauri.jsg.registry.structure.StructureTypeRegistry;
import dev.tauri.jsg.renderer.entity.MastadgeRenderer;
import dev.tauri.jsg.screen.gui.mainmenu.GuiCustomMainMenu;
import dev.tauri.jsg.screen.inventory.dialhomedevice.DHDContainerGui;
import dev.tauri.jsg.screen.inventory.energy.capacitor.CapacitorContainerGui;
import dev.tauri.jsg.screen.inventory.stargate.StargateContainerGui;
import dev.tauri.jsg.screen.provider.ConfigScreenClientRegister;
import dev.tauri.jsg.stargate.StargateTypesLoader;
import dev.tauri.jsg.stargate.network.StargateNetwork;
import dev.tauri.jsg.stargate.network.StargateReservedAddresses;
import dev.tauri.jsg.util.updater.GetUpdate;
import dev.tauri.jsg.worldgen.poolinject.TemplatePoolInjector;
import dev.tauri.jsg.worldgen.poolinject.injectors.StargateTemplatePoolsAdditions;
import dev.tauri.jsg.worldgen.poolinject.injectors.VillageTemplatePoolsAdditions;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.util.LoaderException;
import org.slf4j.LoggerFactory;

@Mod(value="jsg")
public class JSG {
    public static final String MOD_ID = "jsg";
    public static final String MOD_NAME = "Just Stargate Mod";
    public static LoggerWrapper logger;
    public static final String CONFIG_DIMENSIONS_VERSION = "3.0";
    public static String MOD_VERSION;
    public static String MOD_VERSION_ONLY;
    public static final String MC_VERSION = "1.20.1";
    public static File modConfigDir;
    public static File modsDirectory;
    public static File clientModPath;
    public static MinecraftServer currentServer;
    public static final String OC_WRAPPER_LOADED = "dev.tauri.jsg.integration.oc2.OCIntegrationLoaded";
    public static final String OC_WRAPPER_NOT_LOADED = "dev.tauri.jsg.integration.oc2.OCIntegrationNotLoaded";
    public static OCIntegrationWrapper ocWrapper;
    public static final String CC_WRAPPER_LOADED = "dev.tauri.jsg.integration.cctweaked.CCIntegrationLoaded";
    public static final String CC_WRAPPER_NOT_LOADED = "dev.tauri.jsg.integration.cctweaked.CCIntegrationNotLoaded";
    public static CCIntegrationWrapper ccWrapper;
    public static final String OCULUS_WRAPPER_LOADED = "dev.tauri.jsg.integration.oculus.OculusAPIWrapperLoaded";
    public static final String OCULUS_WRAPPER_NOT_LOADED = "dev.tauri.jsg.integration.oculus.OculusAPIWrapperNotLoaded";
    public static OculusAPIWrapper oculusWrapper;
    public static long memoryTotal;
    public static double neededMemory;
    public static final String[] WELCOME_MESS;
    public static BlockPos lastPlayerPosInWorld;

    public static void displayWelcomeMessage() {
        for (String s : WELCOME_MESS) {
            logger.info(s.replaceAll("\\{version}", MOD_VERSION));
        }
    }

    public static Component getInProgress() {
        return Component.m_237113_((String)(String.valueOf(ChatFormatting.AQUA) + "Work In Progress Item!"));
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public JSG() {
        JSGApi.logger = logger = new LoggerWrapper("[jsg] ", LoggerFactory.getLogger((String)MOD_NAME));
        JSGApi.jsgModMainClass = this.getClass();
        JSGApi.SGNGetter = level -> (IStargateNetwork)level.m_8895_().m_164861_(tag -> {
            StargateNetwork sgn = new StargateNetwork();
            sgn.load((CompoundTag)tag);
            return sgn;
        }, StargateNetwork::new, "jsg_stargates");
        JSGApi.loadersHolderGetter = () -> (modId, mainModClass) -> new LoadersHolder((String)modId, new TextureLoader((String)modId, (Class<?>)mainModClass), new ModelLoader((String)modId, (Class<?>)mainModClass));
        StargateTypesLoader.load();
        JSGApi.jsgPointOfOriginsLoader = Constants.JSG_POO_LOADER;
        ModList.get().getModContainerById(MOD_ID).ifPresentOrElse(container -> {
            MOD_VERSION_ONLY = container.getModInfo().getVersion().getQualifier();
            MOD_VERSION = "1.20.1-" + MOD_VERSION_ONLY;
            JSGApi.MOD_VERSION = MOD_VERSION;
            clientModPath = container.getModInfo().getOwningFile().getFile().getFilePath().toFile();
        }, () -> {});
        modConfigDir = FMLPaths.CONFIGDIR.get().toFile();
        modsDirectory = FMLPaths.MODSDIR.get().toFile();
        memoryTotal = Runtime.getRuntime().maxMemory();
        logger.info("Started loading JSG mod in " + clientModPath.getAbsolutePath());
        logger.info("Mods directory: " + modsDirectory.getAbsolutePath());
        logger.info("Loading JSG version " + MOD_VERSION);
        if ((double)memoryTotal < neededMemory) {
            throw new LoaderException("JSG mod requires " + String.format("%.2f", neededMemory / 1024.0 / 1024.0) + "MB of allocated RAM as minimum! (got " + String.format("%.2f", (double)memoryTotal / 1024.0 / 1024.0) + "MB)");
        }
        Constants.JSG_POO_LOADER.setConfigFolder(modConfigDir);
        JSGConfig.load();
        JSGConfig.register();
        InternalIntegrations.tryLoad();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeRunnable & Serializable)() -> ConfigScreenClientRegister.register(MOD_ID, JSGConfig.LIST));
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        SoundRegistry.load();
        MenuTypeRegistry.register(modEventBus);
        FluidRegistry.register(modEventBus);
        logger.info("Successfully registered Fluids!");
        ItemRegistry.register(modEventBus);
        BlockRegistry.register(modEventBus);
        TabRegistry.register(modEventBus);
        BlockEntityRegistry.register(modEventBus);
        SoundRegistry.register(modEventBus);
        EntityRegistry.register(modEventBus);
        VillagerRegistry.register(modEventBus);
        StructureTypeRegistry.register(modEventBus);
        FeatureRegistry.register(modEventBus);
        NotebookPageSerialization.registerInternal();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        JSGPacketHandler.init();
        logger.info("Successfully registered Packets!");
        StargateDimensionConfig.INSTANCE.load(modConfigDir);
        logger.info("Successfully registered Dimensions!");
        StargateRIGConfig.INSTANCE.load(modConfigDir);
        logger.info("Successfully registered RIG config!");
        ProgressJSON.INSTANCE.load(modConfigDir);
        logger.info("Successfully registered Progress data file!");
        StargateSizeEnum.init();
        logger.info("Successfully registered Stargate Sizes!");
        VillageTemplatePoolsAdditions.register();
        StargateTemplatePoolsAdditions.register();
        RaycastersRegistry.registerInternal();
        UniverseDialerModes.load();
        JSG.displayWelcomeMessage();
        Runtime.getRuntime().addShutdownHook(new Thread(JSG::shutDown));
        JSGApi.ADDONS.forEach((modId, addon) -> addon.onJSGLoad());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        JSGAdvancements.register();
        FluidRegistry.registerCauldrons();
        JSGApi.jsgPointOfOriginsLoader.loadServer();
        Map<String, JSGAddon> ADDONS = JSGApi.ADDONS;
        logger.info("Registered addons: ({}) {}", (Object)ADDONS.size(), (Object)String.join((CharSequence)", ", ADDONS.values().stream().map(JSGAddon::getName).toList()));
    }

    @SubscribeEvent
    public void loadCompleteServer(FMLLoadCompleteEvent event) {
        logger.info("Just Stargate Mod loading completed!");
    }

    public static void shutDown() {
        logger.info("Good bye! Thank you for using Just Stargate Mod :)");
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (JSGConfig.C_GENERAL.builtSpec == null || !JSGConfig.C_GENERAL.builtSpec.isLoaded()) {
                return;
            }
            if (!FMLEnvironment.production) {
                return;
            }
            JSGConfig.General.mainMenuMusicVolume.set(GuiCustomMainMenu.musicVolume.doubleValue());
        });
    }

    @SubscribeEvent
    public void onServerBeginStarting(ServerAboutToStartEvent event) {
        JSGApi.currentServer = currentServer = event.getServer();
        TemplatePoolInjector.inject(event.getServer());
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        JSGApi.currentServer = currentServer = event.getServer();
        new StargateNetwork().register(event.getServer().m_129783_().m_8895_());
        StargateReservedAddresses.register();
    }

    @SubscribeEvent
    public void serverStarted(ServerStartedEvent event) throws IOException {
        StargateDimensionConfig.INSTANCE.reload(event.getServer());
        StargateRIGConfig.INSTANCE.reload(event.getServer());
        RecipeManager recipeManager = event.getServer().m_129894_();
        Collection recipes = recipeManager.m_44051_();
        recipes.add(new NotebookRecipe());
        recipes.add(new UniverseDialerCloneRecipe());
        recipes.add(new PageAndUniverseDialerRecipe());
        recipes.add(new StargateOrlinBaseBlockRecipe());
        recipeManager.m_44024_((Iterable)recipes);
        logger.info("Server started!");
    }

    @SubscribeEvent
    public void onCommandsRegister(RegisterCommandsEvent event) {
        JSGCommands.registerCommands(event);
    }

    @SubscribeEvent
    public void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    static {
        MOD_VERSION = "";
        MOD_VERSION_ONLY = "";
        currentServer = null;
        memoryTotal = 0L;
        neededMemory = 1.073741824E9;
        WELCOME_MESS = new String[]{"=======================================", "|     $$$$$\\  $$$$$$\\   $$$$$$\\", "|     \\__$$ |$$  __$$\\ $$  __$$\\", "|        $$ |$$ /  \\__|$$ /  \\__|", "|        $$ |\\$$$$$$\\  $$ |$$$$\\", "|  $$\\   $$ | \\____$$\\ $$ |\\_$$ |", "|  $$ |  $$ |$$\\   $$ |$$ |  $$ |", "|  \\$$$$$$  |\\$$$$$$  |\\$$$$$$  |", "|   \\______/  \\______/  \\______/", "", " Authors: Tau'ri Dev team", " Wiki: https://justsgmod.eu/wiki", " Version: {version}", "======================================="};
        lastPlayerPosInWorld = new BlockPos(0, 0, 0);
    }

    @Mod.EventBusSubscriber(modid="jsg", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                MenuScreens.m_96206_((MenuType)((MenuType)MenuTypeRegistry.STARGATE_MENU_TYPE.get()), StargateContainerGui::new);
                MenuScreens.m_96206_((MenuType)((MenuType)MenuTypeRegistry.CAPACITOR_MENU_TYPE.get()), CapacitorContainerGui::new);
                MenuScreens.m_96206_((MenuType)((MenuType)MenuTypeRegistry.DHD_MENU_TYPE.get()), DHDContainerGui::new);
            });
            EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.MASTADGE.get()), MastadgeRenderer::new);
            GetUpdate.checkForUpdateVoid();
        }

        @SubscribeEvent
        public static void onLoadersRegister(ModelEvent.RegisterGeometryLoaders event) {
            event.register("handheld_item_model", (IGeometryLoader)JSGBlockModel.Loader.INSTANCE);
        }

        public static class LoadingStats {
            public static int loadedTextures = 0;
            public static int notLoadedTextures = 0;
            public static int loadedModels = 0;
            public static int notLoadedModels = 0;
        }
    }
}

