/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api;

import dev.tauri.jsg.api.JSGAddon;
import dev.tauri.jsg.api.LoggerWrapper;
import dev.tauri.jsg.api.client.LoadersHolder;
import dev.tauri.jsg.api.pointoforigins.IPointOfOriginsLoader;
import dev.tauri.jsg.api.stargate.network.IStargateNetwork;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class JSGApi {
    public static final String MOD_ID = "jsg";
    public static String MOD_VERSION;
    public static LoggerWrapper logger;
    public static final Map<String, JSGAddon> ADDONS;
    public static Function<ServerLevel, IStargateNetwork> SGNGetter;
    public static MinecraftServer currentServer;
    public static Supplier<BiFunction<String, Class<?>, LoadersHolder>> loadersHolderGetter;
    public static Class<?> jsgModMainClass;
    public static IPointOfOriginsLoader jsgPointOfOriginsLoader;
    public static BlockPos lastPlayerPosInWorld;

    public static Optional<JSGAddon> getAddon(String id) {
        return Optional.ofNullable(ADDONS.get(id));
    }

    public static void registerAddon(JSGAddon addon) {
        ADDONS.put(addon.getId(), addon);
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static IStargateNetwork getStargateNetwork(ServerLevel level) {
        return SGNGetter.apply(level);
    }

    public static boolean isDevBuild() {
        if (MOD_VERSION == null) {
            return false;
        }
        return MOD_VERSION.toLowerCase().contains("-dev");
    }

    static {
        ADDONS = new HashMap<String, JSGAddon>();
        SGNGetter = null;
        currentServer = null;
        lastPlayerPosInWorld = new BlockPos(0, 0, 0);
    }
}

