/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.tauri.jsg.api.client.model.IOBJModelRenderer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractOBJModel {
    @Nullable
    public static ResourceLocation activeTexture;
    protected static EnumOBJRenderMethod renderType;

    public static void setActiveTexture(@Nullable ResourceLocation texture) {
        activeTexture = texture;
    }

    @Nullable
    public static ResourceLocation getActiveTexture() {
        return activeTexture;
    }

    public static void setGUIRender() {
        renderType = EnumOBJRenderMethod.GUI;
    }

    public static void setLegacyRender() {
        renderType = EnumOBJRenderMethod.LEGACY;
    }

    public static void resetRenderType() {
        renderType = EnumOBJRenderMethod.NORMAL;
    }

    public static EnumOBJRenderMethod getRenderMethod() {
        return renderType;
    }

    public abstract IOBJModelRenderer<?> renderer(EnumOBJRenderMethod var1);

    public abstract boolean isEmpty();

    public void render(PoseStack stack, MultiBufferSource bufferSource, int light) {
        this.render(stack, bufferSource, light, (ResourceLocation)null);
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int light, @Nullable ResourceLocation textureUsed) {
        this.render(stack, bufferSource, light, null, textureUsed);
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int light, @Nullable TextureAtlasSprite textureAtlasSprite) {
        this.render(stack, bufferSource, light, textureAtlasSprite, null);
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int light, @Nullable TextureAtlasSprite textureAtlasSprite, @Nullable ResourceLocation textureUsed) {
        this.render(stack, bufferSource, light, OverlayTexture.f_118083_, false, 1.0f, 1.0f, 1.0f, 1.0f, false, textureAtlasSprite, textureUsed);
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int light, boolean emissiveRendering) {
        this.render(stack, bufferSource, light, emissiveRendering, (ResourceLocation)null);
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int light, boolean emissiveRendering, @Nullable ResourceLocation textureUsed) {
        this.render(stack, bufferSource, light, emissiveRendering, null, textureUsed);
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int light, boolean emissiveRendering, @Nullable TextureAtlasSprite textureAtlasSprite) {
        this.render(stack, bufferSource, light, emissiveRendering, textureAtlasSprite, null);
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int light, boolean emissiveRendering, @Nullable TextureAtlasSprite textureAtlasSprite, @Nullable ResourceLocation textureUsed) {
        this.render(stack, bufferSource, light, OverlayTexture.f_118083_, emissiveRendering, 1.0f, 1.0f, 1.0f, 1.0f, false, textureAtlasSprite, textureUsed);
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering) {
        this.render(stack, bufferSource, light, overlay, emissiveRendering, null);
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, @Nullable ResourceLocation textureUsed) {
        this.render(stack, bufferSource, light, overlay, emissiveRendering, 1.0f, textureUsed);
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int light, boolean emissiveRendering, float color) {
        this.render(stack, bufferSource, light, emissiveRendering, color, null);
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int light, boolean emissiveRendering, float color, @Nullable ResourceLocation textureUsed) {
        this.render(stack, bufferSource, light, OverlayTexture.f_118083_, emissiveRendering, color, textureUsed);
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float color) {
        this.render(stack, bufferSource, light, overlay, emissiveRendering, color, null);
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float color, @Nullable ResourceLocation textureUsed) {
        this.render(stack, bufferSource, light, overlay, emissiveRendering, color, false, textureUsed);
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int light, boolean emissiveRendering, float color, boolean noCulling) {
        this.render(stack, bufferSource, light, emissiveRendering, color, noCulling, null);
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int light, boolean emissiveRendering, float color, boolean noCulling, @Nullable ResourceLocation textureUsed) {
        this.render(stack, bufferSource, light, OverlayTexture.f_118083_, emissiveRendering, color, noCulling, textureUsed);
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float color, boolean noCulling) {
        this.render(stack, bufferSource, light, overlay, emissiveRendering, color, noCulling, null);
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float color, boolean noCulling, @Nullable ResourceLocation textureUsed) {
        this.render(stack, bufferSource, light, overlay, emissiveRendering, color, color, color, 1.0f, noCulling, textureUsed);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float r, float g, float b, float a, boolean noCulling) {
        this.render(poseStack, bufferSource, light, overlay, emissiveRendering, r, g, b, a, noCulling, (ResourceLocation)null);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float r, float g, float b, float a, boolean noCulling, @Nullable ResourceLocation textureUsed) {
        this.render(poseStack, bufferSource, light, overlay, emissiveRendering, r, g, b, a, noCulling, null, textureUsed);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float r, float g, float b, float a, boolean noCulling, @Nullable TextureAtlasSprite textureAtlasSprite) {
        this.render(poseStack, bufferSource, light, overlay, emissiveRendering, r, g, b, a, noCulling, textureAtlasSprite, null);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float r, float g, float b, float a, boolean noCulling, @Nullable TextureAtlasSprite textureAtlasSprite, @Nullable ResourceLocation textureUsed) {
        this.render(AbstractOBJModel.getRenderMethod(), poseStack, bufferSource, light, overlay, emissiveRendering, r, g, b, a, noCulling, textureAtlasSprite, textureUsed);
    }

    public void render(EnumOBJRenderMethod renderType, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float r, float g, float b, float a, boolean noCulling) {
        this.render(renderType, poseStack, bufferSource, light, overlay, emissiveRendering, r, g, b, a, noCulling, (ResourceLocation)null);
    }

    public void render(EnumOBJRenderMethod renderType, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float r, float g, float b, float a, boolean noCulling, @Nullable ResourceLocation textureUsed) {
        this.render(renderType, poseStack, bufferSource, light, overlay, emissiveRendering, r, g, b, a, noCulling, null, textureUsed);
    }

    public void render(EnumOBJRenderMethod renderType, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float r, float g, float b, float a, boolean noCulling, @Nullable TextureAtlasSprite textureAtlasSprite) {
        this.render(renderType, poseStack, bufferSource, light, overlay, emissiveRendering, r, g, b, a, noCulling, textureAtlasSprite, null);
    }

    public void render(EnumOBJRenderMethod renderType, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float r, float g, float b, float a, boolean noCulling, @Nullable TextureAtlasSprite textureAtlasSprite, @Nullable ResourceLocation textureUsed) {
        this.renderer(renderType).render(poseStack, bufferSource, light, overlay, emissiveRendering, r, g, b, a, noCulling, textureAtlasSprite, textureUsed);
    }

    static {
        renderType = EnumOBJRenderMethod.NORMAL;
    }

    public static enum EnumOBJRenderMethod {
        NORMAL,
        GUI,
        LEGACY;

    }
}

