/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fluids.FluidStack;

public class BlockRenderer {
    public static void renderBlockShaded(Level level, BlockPos absoluteWorldPos, BlockState blockState, BlockPos pos, PoseStack stack, MultiBufferSource source, int light, int overlay) {
        RenderShape rendershape = blockState.m_60799_();
        stack.m_85836_();
        stack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
        if (rendershape == RenderShape.MODEL) {
            ModelData modelData = ModelData.EMPTY;
            BlockRenderDispatcher renderer = Minecraft.m_91087_().m_91289_();
            BakedModel bakedModel = renderer.m_110910_(blockState);
            VertexConsumer vertexConsumer = source.m_6299_(RenderType.m_110466_());
            long seed = blockState.m_60726_(absoluteWorldPos);
            for (RenderType rt : bakedModel.getRenderTypes(blockState, RandomSource.m_216335_((long)42L), modelData)) {
                renderer.m_110937_().tesselateBlock((BlockAndTintGetter)level, bakedModel, blockState, absoluteWorldPos, stack, vertexConsumer, true, level.f_46441_, seed, overlay, modelData, rt);
            }
        } else {
            Minecraft.m_91087_().m_91289_().m_110912_(blockState, stack, source, light, overlay);
        }
        stack.m_85849_();
    }

    public static void renderBlock(Level level, BlockPos absoluteWorldPos, BlockState blockState, BlockPos pos, PoseStack stack, MultiBufferSource source, int light, int overlay) {
        BlockRenderer.renderBlock(level, absoluteWorldPos, blockState, pos, stack, source, light, overlay, 1.0f);
    }

    public static void renderBlock(Level level, BlockPos absoluteWorldPos, BlockState blockState, BlockPos pos, PoseStack stack, MultiBufferSource source, int light, int overlay, float alpha) {
        RenderShape rendershape = blockState.m_60799_();
        stack.m_85836_();
        stack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
        if (rendershape == RenderShape.MODEL) {
            BlockRenderDispatcher renderer = Minecraft.m_91087_().m_91289_();
            BakedModel bakedmodel = renderer.m_110910_(blockState);
            ModelData modelData = ModelData.EMPTY;
            for (RenderType rt : bakedmodel.getRenderTypes(blockState, RandomSource.m_216335_((long)42L), modelData)) {
                BlockRenderer.renderModel(stack.m_85850_(), source.m_6299_(RenderType.m_110466_()), blockState, bakedmodel, tintIndex -> Minecraft.m_91087_().m_91298_().m_92577_(blockState, (BlockAndTintGetter)level, absoluteWorldPos, tintIndex.intValue()), alpha, light, overlay, modelData, rt);
            }
        } else {
            Minecraft.m_91087_().m_91289_().m_110912_(blockState, stack, source, light, overlay);
        }
        stack.m_85849_();
    }

    public static void renderModel(PoseStack.Pose pPose, VertexConsumer pConsumer, @Nullable BlockState pState, BakedModel pModel, Function<Integer, Integer> tintColorGetter, float alpha, int pPackedLight, int pPackedOverlay, ModelData modelData, RenderType renderType) {
        RandomSource randomsource = RandomSource.m_216327_();
        for (Direction direction : LevelRenderer.f_109434_) {
            randomsource.m_188584_(42L);
            BlockRenderer.renderQuadList(pPose, pConsumer, tintColorGetter, alpha, pModel.getQuads(pState, direction, randomsource, modelData, renderType), pPackedLight, pPackedOverlay);
        }
        randomsource.m_188584_(42L);
        BlockRenderer.renderQuadList(pPose, pConsumer, tintColorGetter, alpha, pModel.getQuads(pState, null, randomsource, modelData, renderType), pPackedLight, pPackedOverlay);
    }

    private static void renderQuadList(PoseStack.Pose pPose, VertexConsumer pConsumer, Function<Integer, Integer> tintColorGetter, float alpha, List<BakedQuad> pQuads, int pPackedLight, int pPackedOverlay) {
        for (BakedQuad bakedquad : pQuads) {
            Integer color;
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            if (bakedquad.m_111304_() && (color = tintColorGetter.apply(bakedquad.m_111305_())) != -1) {
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                r = Mth.m_14036_((float)red, (float)0.0f, (float)1.0f);
                g = Mth.m_14036_((float)green, (float)0.0f, (float)1.0f);
                b = Mth.m_14036_((float)blue, (float)0.0f, (float)1.0f);
            }
            pConsumer.putBulkData(pPose, bakedquad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, r, g, b, alpha, new int[]{pPackedLight, pPackedLight, pPackedLight, pPackedLight}, pPackedOverlay, true);
        }
    }

    @Nullable
    public static TextureAtlasSprite getFluidTexture(FluidStack fluid, FluidTextureType type) {
        try {
            IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
            if (type == FluidTextureType.STILL) {
                return BlockRenderer.getSprite(props.getStillTexture(fluid));
            }
            return BlockRenderer.getSprite(props.getFlowingTexture(fluid));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static TextureAtlasSprite getSprite(ResourceLocation spriteLocation) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(spriteLocation);
    }

    public static TextureAtlasSprite getSprite(BlockState blockState, Direction direction) {
        ModelManager modelManager = Minecraft.m_91087_().m_91304_();
        BakedModel model = modelManager.m_119430_().m_110893_(blockState);
        List quads = model.m_213637_(blockState, direction, RandomSource.m_216335_((long)42L));
        TextureAtlasSprite bestSprite = model.m_6160_();
        if (quads.isEmpty()) {
            quads = model.m_213637_(blockState, null, RandomSource.m_216327_());
        }
        for (BakedQuad quad : quads) {
            if (quad.m_111305_() != -1 && quads.size() != 1) continue;
            bestSprite = quad.m_173410_();
            break;
        }
        return bestSprite;
    }

    public static enum FluidTextureType {
        STILL,
        FLOWING;

    }
}

