/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.client.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tauri.jsg.api.client.renderer.BlockRenderer;
import dev.tauri.jsg.api.client.screen.util.GuiHelper;
import dev.tauri.jsg.api.client.texture.ITexture;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidTankElement {
    private final int xCoord;
    private final int yCoord;
    private final int maxWidth;
    private final int maxHeight;
    private final FluidTank fluidTank;

    public FluidTankElement(int xCoord, int yCoord, int maxWidth, int maxHeight, FluidTank fluidTank) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.fluidTank = fluidTank;
    }

    public void renderTank(GuiGraphics graphics) {
        if (this.fluidTank != null) {
            ITexture.bindTextureWithMc(InventoryMenu.f_39692_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float height = (float)this.maxHeight * (float)this.fluidTank.getFluidAmount() / (float)this.fluidTank.getCapacity();
            TextureAtlasSprite sprite = BlockRenderer.getFluidTexture(this.fluidTank.getFluid(), BlockRenderer.FluidTextureType.STILL);
            if (sprite == null) {
                return;
            }
            GuiHelper.currentStack = graphics.m_280168_();
            GuiHelper.drawTiledSprite(this.xCoord, this.yCoord + this.maxHeight, 0, this.maxWidth, (int)height, sprite);
        }
    }

    public void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (GuiHelper.isPointInRegion(this.xCoord, this.yCoord, this.maxWidth, this.maxHeight, mouseX, mouseY) && this.fluidTank != null) {
            String amount = String.format("%,d", this.fluidTank.getFluidAmount());
            String maxAmount = String.format("%,d", this.fluidTank.getCapacity());
            graphics.m_280677_(Minecraft.m_91087_().f_91062_, List.of(this.fluidTank.getFluid().getDisplayName(), Component.m_237113_((String)(amount + " / " + maxAmount + " mB")).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY))), Optional.empty(), mouseX, mouseY);
        }
    }
}

