/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.config.ingame.option.type;

import dev.tauri.jsg.api.config.ingame.BEConfig;
import dev.tauri.jsg.api.config.ingame.BEConfigOptionWidget;
import dev.tauri.jsg.api.config.ingame.option.type.AbstractBEConfigOption;
import dev.tauri.jsg.api.config.ingame.widget.IntegerBEConfigOptionWidget;
import dev.tauri.jsg.api.config.ingame.widget.RangedIntBEConfigOptionWidget;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntegerBEConfigOption
extends AbstractBEConfigOption<Integer> {
    protected final OptionalInt min;
    protected final OptionalInt max;

    public IntegerBEConfigOption(Runnable onChanged, int defaultValue) {
        this(onChanged, defaultValue, OptionalInt.empty(), OptionalInt.empty());
    }

    public IntegerBEConfigOption(Runnable onChanged, int defaultValue, int min) {
        this(onChanged, defaultValue, OptionalInt.of(min), OptionalInt.empty());
    }

    public IntegerBEConfigOption(Runnable onChanged, int defaultValue, int min, int max) {
        this(onChanged, defaultValue, OptionalInt.of(min), OptionalInt.of(max));
    }

    public IntegerBEConfigOption(Runnable onChanged, int defaultValue, OptionalInt min, OptionalInt max) {
        super(onChanged, defaultValue);
        this.min = min;
        this.max = max;
    }

    public OptionalInt getMin() {
        return this.min;
    }

    public OptionalInt getMax() {
        return this.max;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public BEConfigOptionWidget<Integer> createGUIWidget(BEConfig config, int tabWidth, String optionId) {
        if (this.min.isPresent() && this.max.isPresent()) {
            return new RangedIntBEConfigOptionWidget(config, optionId, tabWidth, this);
        }
        return new IntegerBEConfigOptionWidget(config, optionId, tabWidth, this);
    }

    @Override
    @NotNull
    public Optional<Integer> parseValue(Object value) {
        if (!(value instanceof Integer)) {
            return Optional.empty();
        }
        Integer intVal = (Integer)value;
        return Optional.of(intVal);
    }

    @Override
    public void setValue(Integer value) {
        if (this.max.isPresent() && this.max.getAsInt() < value) {
            value = this.max.getAsInt();
        }
        if (this.min.isPresent() && this.min.getAsInt() > value) {
            value = this.min.getAsInt();
        }
        super.setValue(value);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(((Integer)this.getValue()).intValue());
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.setValue(buf.readInt());
    }

    @Override
    public void serializeToNBT(String selfId, CompoundTag tag) {
        tag.m_128405_(selfId, ((Integer)this.getValue()).intValue());
        super.serializeToNBT(selfId, tag);
    }

    @Override
    public void deserializeFromNBT(String selfId, CompoundTag tag) {
        this.setValue(tag.m_128451_(selfId));
        super.deserializeFromNBT(selfId, tag);
    }
}

