/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.config.values;

import dev.tauri.jsg.api.config.screen.entry.AbstractConfigEntry;
import dev.tauri.jsg.api.config.screen.entry.BooleanConfigEntry;
import dev.tauri.jsg.api.config.screen.entry.DoubleConfigEntry;
import dev.tauri.jsg.api.config.screen.entry.EnumConfigEntry;
import dev.tauri.jsg.api.config.screen.entry.IntConfigEntry;
import dev.tauri.jsg.api.config.screen.entry.LongConfigEntry;
import dev.tauri.jsg.api.config.screen.entry.SliderConfigEntry;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class JSGConfigValue {
    public final List<String> comment;

    public JSGConfigValue(List<String> comment) {
        this.comment = comment;
    }

    public abstract AbstractConfigEntry getGuiEntry(int var1);

    public abstract String getPath();

    public static class ListStringValue
    extends JSGConfigValue {
        public ForgeConfigSpec.ConfigValue<List<? extends String>> value;

        public ListStringValue(ForgeConfigSpec.Builder builder, String path, List<? extends String> defaultValue, String ... comment) {
            super(List.of(comment));
            this.value = builder.comment(comment).define(path, defaultValue);
        }

        public void set(List<? extends String> value) {
            this.value.set(value);
            this.value.save();
        }

        public List<? extends String> get() {
            return (List)this.value.get();
        }

        public List<? extends String> getDefault() {
            return (List)this.value.getDefault();
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public AbstractConfigEntry getGuiEntry(int width) {
            return null;
        }

        @Override
        public String getPath() {
            return String.join((CharSequence)".", this.value.getPath());
        }
    }

    public static class EnumValue<T extends Enum<T>>
    extends JSGConfigValue {
        public ForgeConfigSpec.EnumValue<T> enumValue;

        public EnumValue(ForgeConfigSpec.Builder builder, String path, T defaultValue, String ... comment) {
            super(List.of(comment));
            this.enumValue = builder.comment(comment).defineEnum(path, defaultValue);
        }

        public void set(T value) {
            this.enumValue.set(value);
            this.enumValue.save();
        }

        public T get() {
            return (T)((Enum)this.enumValue.get());
        }

        public T getDefault() {
            return (T)((Enum)this.enumValue.getDefault());
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public AbstractConfigEntry getGuiEntry(int width) {
            return new EnumConfigEntry((Component)Component.m_237113_((String)((String)this.enumValue.getPath().get(this.enumValue.getPath().size() - 1))), width, this);
        }

        @Override
        public String getPath() {
            return String.join((CharSequence)".", this.enumValue.getPath());
        }
    }

    public static class RGBAValue
    extends JSGConfigValue {
        public Component path;
        public String sPath;
        public ForgeConfigSpec.IntValue redValue;
        public ForgeConfigSpec.IntValue greenValue;
        public ForgeConfigSpec.IntValue blueValue;
        public Optional<ForgeConfigSpec.IntValue> alphaValue = Optional.empty();

        public RGBAValue(ForgeConfigSpec.Builder builder, String path, int red, int blue, int green, String ... comment) {
            super(List.of(comment));
            this.sPath = String.join((CharSequence)".", path);
            this.path = Component.m_237113_((String)this.sPath);
            builder.comment(comment);
            this.redValue = builder.defineInRange(path + ".red", red, 0, 255);
            this.greenValue = builder.defineInRange(path + ".green", blue, 0, 255);
            this.blueValue = builder.defineInRange(path + ".blue", green, 0, 255);
        }

        public RGBAValue(ForgeConfigSpec.Builder builder, String path, int red, int blue, int green, int alpha, String ... comment) {
            super(List.of(comment));
            builder.comment(comment);
            this.redValue = builder.defineInRange(path + ".red", red, 0, 255);
            this.greenValue = builder.defineInRange(path + ".green", blue, 0, 255);
            this.blueValue = builder.defineInRange(path + ".blue", green, 0, 255);
            this.alphaValue = Optional.of(builder.defineInRange(path + ".alpha", alpha, 0, 255));
        }

        public int get() {
            return (this.hasAlpha() ? this.getAlpha() << 24 : 0) | (this.getRed() << 16 | this.getGreen() << 8 | this.getBlue());
        }

        public void setRed(int value) {
            this.redValue.set((Object)value);
            this.redValue.save();
        }

        public void setGreen(int value) {
            this.greenValue.set((Object)value);
            this.greenValue.save();
        }

        public void setBlue(int value) {
            this.blueValue.set((Object)value);
            this.blueValue.save();
        }

        public void setAlpha(int value) {
            if (this.alphaValue.isEmpty()) {
                return;
            }
            this.alphaValue.get().set((Object)value);
            this.alphaValue.get().save();
        }

        public boolean hasAlpha() {
            return this.alphaValue.isPresent();
        }

        public int getRed() {
            return (Integer)this.redValue.get();
        }

        public int getGreen() {
            return (Integer)this.greenValue.get();
        }

        public int getBlue() {
            return (Integer)this.blueValue.get();
        }

        public int getAlpha() {
            if (this.alphaValue.isEmpty()) {
                return 255;
            }
            return (Integer)this.alphaValue.get().get();
        }

        public int getRedDefault() {
            return (Integer)this.redValue.getDefault();
        }

        public int getGreenDefault() {
            return (Integer)this.greenValue.getDefault();
        }

        public int getBlueDefault() {
            return (Integer)this.blueValue.getDefault();
        }

        public int getAlphaDefault() {
            if (this.alphaValue.isEmpty()) {
                return 255;
            }
            return (Integer)this.alphaValue.get().getDefault();
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public AbstractConfigEntry getGuiEntry(int width) {
            return null;
        }

        @Override
        public String getPath() {
            return this.sPath;
        }
    }

    public static class LongValue
    extends JSGConfigValue {
        public ForgeConfigSpec.LongValue longValue;

        public LongValue(ForgeConfigSpec.Builder builder, String path, long defaultValue, long min, long max, String ... comment) {
            super(List.of(comment));
            this.longValue = builder.comment(comment).defineInRange(path, defaultValue, min, max);
        }

        public void set(long value) {
            this.longValue.set((Object)value);
            this.longValue.save();
        }

        public long get() {
            return (Long)this.longValue.get();
        }

        public long getDefault() {
            return (Long)this.longValue.getDefault();
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public AbstractConfigEntry getGuiEntry(int width) {
            return new LongConfigEntry((Component)Component.m_237113_((String)((String)this.longValue.getPath().get(this.longValue.getPath().size() - 1))), width, this);
        }

        @Override
        public String getPath() {
            return String.join((CharSequence)".", this.longValue.getPath());
        }
    }

    public static class DoubleValue
    extends JSGConfigValue {
        public ForgeConfigSpec.DoubleValue value;
        protected boolean slider = false;
        protected double min;
        protected double max;

        public DoubleValue(ForgeConfigSpec.Builder builder, String path, double defaultValue, double min, double max, boolean hasSlider, String ... comment) {
            this(builder, path, defaultValue, min, max, comment);
            this.slider = hasSlider;
        }

        public DoubleValue(ForgeConfigSpec.Builder builder, String path, double defaultValue, double min, double max, String ... comment) {
            super(List.of(comment));
            this.value = builder.comment(comment).defineInRange(path, defaultValue, min, max);
            this.min = min;
            this.max = max;
        }

        public void set(double value) {
            this.value.set((Object)value);
            this.value.save();
        }

        public double get() {
            return (Double)this.value.get();
        }

        public boolean hasSlider() {
            return this.slider;
        }

        public double getDefault() {
            return (Double)this.value.getDefault();
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public AbstractConfigEntry getGuiEntry(int width) {
            if (this.hasSlider()) {
                return new SliderConfigEntry((Component)Component.m_237113_((String)((String)this.value.getPath().get(this.value.getPath().size() - 1))), (Component)Component.m_237119_(), width, this);
            }
            return new DoubleConfigEntry((Component)Component.m_237113_((String)((String)this.value.getPath().get(this.value.getPath().size() - 1))), width, this);
        }

        @Override
        public String getPath() {
            return String.join((CharSequence)".", this.value.getPath());
        }
    }

    public static class IntValue
    extends JSGConfigValue {
        public ForgeConfigSpec.IntValue intValue;
        protected int min;
        protected int max;

        public IntValue(ForgeConfigSpec.Builder builder, String path, int defaultValue, int min, int max, String ... comment) {
            super(List.of(comment));
            this.intValue = builder.comment(comment).defineInRange(path, defaultValue, min, max);
            this.min = min;
            this.max = max;
        }

        public void set(int value) {
            this.intValue.set((Object)value);
            this.intValue.save();
        }

        public int get() {
            return (Integer)this.intValue.get();
        }

        public int getDefault() {
            return (Integer)this.intValue.getDefault();
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public AbstractConfigEntry getGuiEntry(int width) {
            return new IntConfigEntry((Component)Component.m_237113_((String)((String)this.intValue.getPath().get(this.intValue.getPath().size() - 1))), width, this);
        }

        @Override
        public String getPath() {
            return String.join((CharSequence)".", this.intValue.getPath());
        }
    }

    public static class BooleanValue
    extends JSGConfigValue {
        public ForgeConfigSpec.BooleanValue booleanValue;

        public BooleanValue(ForgeConfigSpec.Builder builder, String path, boolean defaultValue, String ... comment) {
            super(List.of(comment));
            this.booleanValue = builder.comment(comment).define(path, defaultValue);
        }

        public void set(boolean value) {
            this.booleanValue.set((Object)value);
            this.booleanValue.save();
        }

        public boolean get() {
            return (Boolean)this.booleanValue.get();
        }

        public boolean getDefault() {
            return (Boolean)this.booleanValue.getDefault();
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public AbstractConfigEntry getGuiEntry(int width) {
            return new BooleanConfigEntry((Component)Component.m_237113_((String)((String)this.booleanValue.getPath().get(this.booleanValue.getPath().size() - 1))), width, this);
        }

        @Override
        public String getPath() {
            return String.join((CharSequence)".", this.booleanValue.getPath());
        }
    }
}

