/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.integration;

import dev.tauri.jsg.api.integration.ComputerDeviceProvider;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;

@ParametersAreNonnullByDefault
@FieldsAreNonnullByDefault
public class SignalHolder {
    protected final String eventName;
    protected final Object[] args;

    public static SignalHolder of(String eventName, Object ... args) {
        return new SignalHolder(eventName, args);
    }

    private SignalHolder(String eventName, Object[] args) {
        this.eventName = eventName;
        this.args = args;
    }

    public void sendVia(ComputerDeviceProvider provider) {
        provider.sendSignal(this);
    }

    public String eventName() {
        return this.eventName;
    }

    public Object[] args() {
        return this.args;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof SignalHolder) {
            SignalHolder otherHolder = (SignalHolder)other;
            return Objects.equals(this.eventName, otherHolder.eventName()) && Arrays.equals(this.args, otherHolder.args());
        }
        return false;
    }

    public int hashCode() {
        return this.eventName.hashCode() * 19 + Arrays.hashCode(this.args);
    }

    public String toString() {
        return "<" + this.eventName() + "," + Arrays.toString(this.args()) + ">";
    }
}

