/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.pointoforigins;

import dev.tauri.jsg.api.JSGApi;
import dev.tauri.jsg.api.pointoforigins.IPointOfOriginType;
import dev.tauri.jsg.api.pointoforigins.PointOfOrigin;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.progress.ProgressMeter;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
public interface IPointOfOriginsLoader {
    public static final String VARIANT_DHD = "dhd.obj";
    public static final String VARIANT_DHD_LIGHT = "dhd_light.obj";
    public static final String VARIANT_GATE = "stargate.obj";
    public static final String VARIANT_ICON = "icon.png";
    public static final String VARIANT_GATE_PNG = "stargate.png";
    public static final String VARIANT_GATE_OFF_PNG = "stargate_off.png";

    public Optional<Map<ResourceLocation, PointOfOrigin>> getLoadedOrigins(IPointOfOriginType var1);

    public Map<IPointOfOriginType, Map<ResourceLocation, PointOfOrigin>> getLoadedOrigins();

    public Map<IPointOfOriginType, List<ResourceLocation>> getRegisteredPointOfOrigins();

    @Nullable
    default public PointOfOrigin getOriginByIdOrElse(IPointOfOriginType type, ResourceLocation id, @Nullable Supplier<PointOfOrigin> fallback) {
        Optional<Map<ResourceLocation, PointOfOrigin>> mapOpt = this.getLoadedOrigins(type);
        if (mapOpt.isEmpty()) {
            if (fallback == null) {
                return null;
            }
            return fallback.get();
        }
        Map<ResourceLocation, PointOfOrigin> map = mapOpt.get();
        PointOfOrigin origin = map.get(id);
        if (origin == null) {
            if (fallback == null) {
                return null;
            }
            return fallback.get();
        }
        return origin;
    }

    public void registerPoOType(IPointOfOriginType var1);

    public Optional<IPointOfOriginType> getPoOType(String var1);

    public void loadServer();

    public int getTotalCount();

    public void loadResources(ProgressMeter var1);

    @Nullable
    public PointOfOrigin getOriginFor(IPointOfOriginType var1, ResourceKey<Level> var2, BiomeOverlayRegistry.BiomeOverlayInstance var3);

    public static interface Defaults {
        @Nullable
        public static PointOfOrigin get(IPointOfOriginType type, ResourceLocation location) {
            return JSGApi.jsgPointOfOriginsLoader.getOriginByIdOrElse(type, location, null);
        }

        public static interface MilkyWay {
            public static final ResourceLocation DEFAULT = new ResourceLocation("jsg", "default");
            public static final ResourceLocation P7J_989 = new ResourceLocation("jsg", "p7j989");
            public static final ResourceLocation NETHER = new ResourceLocation("jsg", "nether");
            public static final ResourceLocation ANTARCTICA = new ResourceLocation("jsg", "antarctica");
            public static final ResourceLocation ABYDOS = new ResourceLocation("jsg", "abydos");
            public static final ResourceLocation TAURI = new ResourceLocation("jsg", "tauri");
        }
    }
}

