/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.power.general;

import dev.tauri.jsg.api.config.JSGConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemEnergyStorage
implements IEnergyStorage {
    protected final ItemStack stack;
    protected final int maxEnergyStored;

    public ItemEnergyStorage(ItemStack stack, int maxEnergyStored) {
        this.stack = stack;
        this.maxEnergyStored = maxEnergyStored;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyStored = this.getEnergyStored();
        int energyReceived = Math.min(this.getMaxEnergyStored() - energyStored, Math.min(JSGConfig.Stargate.stargateMaxEnergyTransfer.get(), maxReceive));
        if (!simulate) {
            this.setEnergyStored(energyStored + energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (maxExtract > this.getEnergyStored()) {
            maxExtract = this.getEnergyStored();
        }
        if (!simulate) {
            this.setEnergyStored(this.getEnergyStored() - maxExtract);
        }
        return maxExtract;
    }

    public void setEnergyStored(int energy) {
        this.getOrCreateCompound(this.stack).m_128405_("energy", energy);
    }

    public int getEnergyStored() {
        return this.getOrCreateCompound(this.stack).m_128451_("energy");
    }

    public int getMaxEnergyStored() {
        return this.maxEnergyStored;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    protected CompoundTag getOrCreateCompound(ItemStack stack) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        return stack.m_41783_();
    }
}

