/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.sound.client;

import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.sound.IPositionedSound;
import dev.tauri.jsg.api.sound.ISoundEvent;
import dev.tauri.jsg.api.sound.client.FlybySoundInstance;
import dev.tauri.jsg.api.sound.client.JSGMainMenuSound;
import dev.tauri.jsg.api.sound.client.JSGPositionedSound;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class JSGSoundHelperClient {
    private static final Map<BlockPos, Map<IPositionedSound, JSGPositionedSound>> POSITIONED_SOUND_RECORDS_MAP = new HashMap<BlockPos, Map<IPositionedSound, JSGPositionedSound>>();
    private static final Map<IPositionedSound, JSGMainMenuSound> MAINMENU_SOUND_RECORDS_MAP = new HashMap<IPositionedSound, JSGMainMenuSound>();

    public static JSGPositionedSound getRecord(IPositionedSound soundEnum, BlockPos pos) {
        Map soundRecordsMapPos = POSITIONED_SOUND_RECORDS_MAP.computeIfAbsent(pos, k -> new HashMap());
        JSGPositionedSound soundRecord = (JSGPositionedSound)((Object)soundRecordsMapPos.get(soundEnum));
        if (soundRecord == null) {
            soundRecord = soundEnum.getInstance(pos);
            soundRecordsMapPos.put(soundEnum, soundRecord);
            POSITIONED_SOUND_RECORDS_MAP.put(pos, soundRecordsMapPos);
        }
        return soundRecord;
    }

    public static void playPositionedSoundClientSide(BlockPos pos, IPositionedSound soundEnum, boolean play) {
        if (pos == null) {
            return;
        }
        JSGPositionedSound soundRecord = JSGSoundHelperClient.getRecord(soundEnum, pos);
        if (play) {
            soundRecord.play();
        } else {
            soundRecord.stopPlaying();
        }
    }

    public static void playSoundEventClientSide(BlockPos pos, ISoundEvent sound, float volumeModifier, float pitchModifier) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance((SoundEvent)sound.getInstance().get(), SoundSource.AMBIENT, (float)((double)sound.getVolume() * JSGConfig.General.volume.get()) * volumeModifier, pitchModifier, RandomSource.m_216327_(), pos));
    }

    public static FlybySoundInstance playPositionedFlyBySound(BlockPos pos, IPositionedSound sound, float volumeModifier, float pitchModifier) {
        FlybySoundInstance ins = new FlybySoundInstance((SoundEvent)sound.getInstance().get(), SoundSource.AMBIENT, sound.getVolume() * volumeModifier, pitchModifier, RandomSource.m_216327_(), pos);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)ins);
        return ins;
    }

    public static JSGMainMenuSound getRecordMainMenu(Supplier<Float> volumeSupplier, IPositionedSound soundEnum) {
        JSGMainMenuSound soundRecord = MAINMENU_SOUND_RECORDS_MAP.get(soundEnum);
        if (soundRecord == null) {
            soundRecord = soundEnum.getInstanceAbsolute(volumeSupplier);
            MAINMENU_SOUND_RECORDS_MAP.put(soundEnum, soundRecord);
        }
        soundRecord.volumeSupplier = volumeSupplier;
        return soundRecord;
    }

    public static void playMainMenuTheme(Supplier<Float> volumeSupplier, IPositionedSound soundEnum, boolean play) {
        JSGMainMenuSound soundRecord = JSGSoundHelperClient.getRecordMainMenu(volumeSupplier, soundEnum);
        if (play) {
            soundRecord.play();
        } else {
            soundRecord.stopPlaying();
        }
    }
}

