/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.stargate;

import dev.tauri.jsg.api.JSGApi;
import dev.tauri.jsg.api.integration.ComputerDeviceProvider;
import dev.tauri.jsg.api.multistructure.merging.IMergeHelper;
import dev.tauri.jsg.api.pointoforigins.IPointOfOriginType;
import dev.tauri.jsg.api.pointoforigins.PointOfOrigin;
import dev.tauri.jsg.api.power.JSGEnergyStorage;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import dev.tauri.jsg.api.registry.ScheduledTaskType;
import dev.tauri.jsg.api.sound.IPositionedSound;
import dev.tauri.jsg.api.sound.ISoundEvent;
import dev.tauri.jsg.api.sound.StargateSoundEventEnum;
import dev.tauri.jsg.api.sound.StargateSoundPositionedEnum;
import dev.tauri.jsg.api.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.api.stargate.iris.codesender.CodeSender;
import dev.tauri.jsg.api.stargate.listener.IStargateListenerHandler;
import dev.tauri.jsg.api.stargate.manager.IStargateAutoCloseManager;
import dev.tauri.jsg.api.stargate.manager.IStargateDialingManager;
import dev.tauri.jsg.api.stargate.manager.IStargateEnergyManager;
import dev.tauri.jsg.api.stargate.manager.IStargateEventHorizonManager;
import dev.tauri.jsg.api.stargate.manager.IStargateRIGManager;
import dev.tauri.jsg.api.stargate.manager.IStargateSoundManager;
import dev.tauri.jsg.api.stargate.manager.IStargateStateManager;
import dev.tauri.jsg.api.stargate.network.IStargateNetwork;
import dev.tauri.jsg.api.stargate.network.StargatePos;
import dev.tauri.jsg.api.stargate.network.address.StargateAddress;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolUsage;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolUtil;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.stargate.type.StargateType;
import dev.tauri.jsg.api.state.IStateProvider;
import dev.tauri.jsg.api.util.IStargateGenerator;
import dev.tauri.jsg.api.util.JSGAxisAlignedBB;
import dev.tauri.jsg.api.util.RotationUtil;
import dev.tauri.jsg.api.util.blockentity.IPreparable;
import dev.tauri.jsg.api.util.blockentity.ITickable;
import dev.tauri.jsg.api.util.blockentity.ScheduledTaskExecutorInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface Stargate<E extends JSGEnergyStorage>
extends IPreparable,
ITickable,
ScheduledTaskExecutorInterface,
IStateProvider,
ComputerDeviceProvider {
    public static int[] getRandomSymbolsToDisplay(int maxSymbols, Predicate<Integer> shouldDisplaySymbol) {
        ArrayList<Integer> symbolsToDisplay = new ArrayList<Integer>();
        if (maxSymbols < 1) {
            return new int[0];
        }
        if (maxSymbols > 8) {
            maxSymbols = 8;
        }
        for (int i = 1; i <= maxSymbols; ++i) {
            if (!shouldDisplaySymbol.test(i)) continue;
            symbolsToDisplay.add(i);
        }
        if (shouldDisplaySymbol.test(9)) {
            symbolsToDisplay.add(9);
        }
        int[] symbolToDisplayArray = new int[symbolsToDisplay.size()];
        for (int i = 0; i < symbolsToDisplay.size(); ++i) {
            symbolToDisplayArray[i] = (Integer)symbolsToDisplay.get(i);
        }
        return symbolToDisplayArray;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public static PointOfOrigin getOriginFor(IPointOfOriginType pointOfOriginType, ResourceKey<Level> dimension, BiomeOverlayRegistry.BiomeOverlayInstance biomeOverlayInstance) {
        return Optional.ofNullable(JSGApi.jsgPointOfOriginsLoader.getOriginFor(pointOfOriginType, dimension, biomeOverlayInstance)).orElse(pointOfOriginType.getDefaultPoO());
    }

    private BlockEntity self() {
        return (BlockEntity)this;
    }

    public long getTime();

    public void initStargatePos();

    public StargatePos getStargatePos();

    default public boolean is(@Nullable Stargate<?> stargate) {
        if (stargate == null) {
            return false;
        }
        return stargate.getStargatePos().equals(this.getStargatePos());
    }

    default public boolean is(@Nullable StargatePos stargatePos) {
        if (stargatePos == null) {
            return false;
        }
        return stargatePos.equals(this.getStargatePos());
    }

    default public BlockPos getGateCenterPos() {
        return this.relative(new BlockPos(0, 4, 0));
    }

    public AbstractSymbolType<?> getSymbolType();

    public StargateType getStargateType();

    default public int getMaxChevrons() {
        return 7;
    }

    default public boolean receiveIrisCode(CodeSender sender, String code) {
        return false;
    }

    default public boolean isRIGAllowed() {
        return false;
    }

    public boolean isBlackHoleEffected();

    default public boolean isGateBurried() {
        return false;
    }

    default public void onBlockBroken() {
        this.getNetwork().removeStargate(this.getStargatePos());
    }

    default public void onGateBroken() {
        this.onBlockBroken();
        this.onGateUnmerged(false);
    }

    public void onGateUnmerged(boolean var1);

    public void onGateMerged();

    default public int getOpenSoundDelay() {
        return ScheduledTaskType.STARGATE_OPEN_SOUND.waitTicks;
    }

    default public int getCloseSoundDelay() {
        return ScheduledTaskType.STARGATE_CLOSE_SOUND.waitTicks;
    }

    default public boolean sendIrisCode(CodeSender sender, String code) {
        return this.getDialingManager().getConnection().callConnected((conn, sg) -> {
            if (!conn.getStatus().full()) {
                return false;
            }
            return sg.receiveIrisCode(sender, code);
        }, () -> false);
    }

    public IStargateNetwork getNetwork();

    public void regenerateStargate(IStargateGenerator.PlacementConfig var1);

    public void tryRegenerateStargateIfNeeded();

    public Map<AbstractSymbolType<?>, StargateAddress> getAddressMap();

    @Nullable
    public StargateAddress getStargateAddress(AbstractSymbolType<?> var1);

    public void setGateAddress(AbstractSymbolType<?> var1, StargateAddress var2);

    default public void generateAddresses(boolean reset) {
        Level level = this.getStargateLevel();
        if (level == null) {
            return;
        }
        this.initStargatePos();
        StargatePos stargatePos = this.getStargatePos();
        if (stargatePos == null) {
            return;
        }
        if (reset) {
            this.getNetwork().removeStargate(this.getStargatePos());
        }
        long seed = (long)this.blockPosition().hashCode() * 31L + (long)level.m_46472_().m_135782_().hashCode();
        JSGApi.logger.debug("Seed for stargate {} address gen is {}", (Object)stargatePos.toString(), (Object)seed);
        Random random = new Random(seed);
        for (AbstractSymbolType<?> symbolType : AbstractSymbolType.values(SymbolUsage.STARGATES)) {
            StargatePos sgnPos;
            StargateAddress address = this.getStargateAddress(symbolType);
            if (address != null && !reset) continue;
            IStargateNetwork sgn = this.getNetwork();
            address = new StargateAddress(symbolType);
            do {
                address.clear();
                address.generate(random);
                sgnPos = sgn.getStargate(address);
                JSGApi.logger.debug("Generating address for gate at {}, symbol type {}: {} ", stargatePos.toString(), symbolType.getId(), address.getNameList());
            } while (sgnPos != null && !sgnPos.equals(stargatePos));
            this.setGateAddress(symbolType, address);
        }
    }

    public void renameStargatePos(String var1);

    public void refresh();

    default public SymbolInterface getSymbolFromNameIndex(Object nameIndex) throws IllegalArgumentException {
        return SymbolUtil.getSymbolFromNameIndexOrThrow(this.getSymbolType(), nameIndex);
    }

    public ItemStack getAddressPage(AbstractSymbolType<?> var1, ItemStack var2, int[] var3);

    @Nullable
    public PointOfOrigin getPointOfOrigin(AbstractSymbolType<?> var1);

    @Nullable
    public PointOfOrigin getPointOfOrigin(IPointOfOriginType var1);

    @Nullable
    default public PointOfOrigin getPointOfOrigin() {
        return this.getPointOfOrigin(this.getPointOfOriginType());
    }

    default public IPointOfOriginType getPointOfOriginType() {
        return this.getStargateType();
    }

    public List<BiomeOverlayRegistry.BiomeOverlayInstance> getSupportedOverlays();

    default public BiomeOverlayRegistry.BiomeOverlayInstance getBiomeOverlayWithOverride(boolean override) {
        Level world = this.getStargateLevel();
        if (world == null) {
            return BiomeOverlayRegistry.NORMAL;
        }
        return BiomeOverlayRegistry.getUpdatedBiomeOverlay(world, this.getMergeHelper().getTopBlock(), this.getSupportedOverlays());
    }

    public boolean shouldAutoclose();

    public IStargateAutoCloseManager getAutoCloseManager();

    public void updateFacing();

    default public String getOpenedSecondsToDisplayAsMinutes() {
        long openedSeconds = this.getDialingManager().getConnection().getSecondsOpen();
        if (openedSeconds < 1L) {
            return "Closed!";
        }
        int minutes = (int)Math.floor((double)openedSeconds / 60.0);
        int seconds = (int)(openedSeconds - (long)(60 * minutes));
        String secondsString = seconds < 10 ? "0" + seconds : "" + seconds;
        return minutes + ":" + secondsString + "min";
    }

    public void generateMergeHelper();

    public IMergeHelper getMergeHelper();

    public void setMerged(boolean var1);

    public boolean isMerged();

    @Nullable
    public IPositionedSound getPositionedSound(StargateSoundPositionedEnum var1);

    @Nullable
    public ISoundEvent getSoundEvent(StargateSoundEventEnum var1);

    default public void playPositionedSound(StargateSoundPositionedEnum soundEnum, boolean play) {
        IPositionedSound positionedSound = this.getPositionedSound(soundEnum);
        if (positionedSound == null) {
            return;
        }
        this.playPositionedSound(positionedSound, play);
    }

    public void playPositionedSound(IPositionedSound var1, boolean var2);

    default public void playSoundEvent(StargateSoundEventEnum soundEnum) {
        ISoundEvent soundEvent = this.getSoundEvent(soundEnum);
        if (soundEvent == null) {
            return;
        }
        this.playSoundEvent(soundEvent, this.getSoundEventPitch(soundEnum));
    }

    default public float getSoundEventPitch(StargateSoundEventEnum soundEvent) {
        return 1.0f;
    }

    default public void playSoundEvent(ISoundEvent soundEnum) {
        this.playSoundEvent(soundEnum, 1.0f);
    }

    public void playSoundEvent(ISoundEvent var1, float var2);

    public IStargateDialingManager createDialingManager();

    public IStargateStateManager createStateManager();

    public IStargateEnergyManager<E> createEnergyManager();

    public IStargateSoundManager createSoundManager();

    public IStargateEventHorizonManager createEventHorizonManager();

    public IStargateDialingManager getDialingManager();

    public IStargateEnergyManager<E> getEnergyManager();

    public IStargateStateManager getStateManager();

    public IStargateSoundManager getSoundManager();

    public IStargateRIGManager getRIGManager();

    public IStargateListenerHandler getListenerHandler();

    public IStargateEventHorizonManager getEventHorizonManager();

    @Nullable
    default public Level getStargateLevel() {
        return this.self().m_58904_();
    }

    default public RandomSource getRandom() {
        return this.getStargateLevel() == null ? RandomSource.m_216327_() : this.getStargateLevel().f_46441_;
    }

    default public BlockState getStargateBlockState() {
        return this.self().m_58900_();
    }

    default public void setStargateChanged() {
        this.self().m_6596_();
    }

    default public void onStargateLoaded() {
        Level level = this.getStargateLevel();
        if (level == null) {
            return;
        }
        if (!level.m_5776_()) {
            this.getStateManager().onLoad(level);
            this.tryRegenerateStargateIfNeeded();
            this.generateAddresses(false);
            this.setStargateChanged();
            this.updateFacing();
            this.generateMergeHelper();
        } else {
            this.getStateManager().onLoad(level);
        }
        this.getDialingManager().onLoad(level);
        this.getEventHorizonManager().onLoad(level);
        this.getSoundManager().onLoad(level);
    }

    @Override
    default public void tick(Level level) {
        this.getStateManager().tick(level);
        this.getDialingManager().tick(level);
        this.getRIGManager().tick(level);
        this.getMergeHelper().tick(level);
        this.getEnergyManager().tick(level);
        this.getEventHorizonManager().tick(level);
        this.getSoundManager().tick(level);
        if (level.f_46443_) {
            return;
        }
        if (this.getTime() % 20L == 0L && this.shouldAutoclose()) {
            this.getDialingManager().attemptClose(StargateClosedReasonEnum.AUTOCLOSE);
        }
    }

    default public BlockPos blockPosition() {
        return this.self().m_58899_();
    }

    default public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return this.self().getCapability(capability, facing);
    }

    public <T> LazyOptional<T> getStargateCapability(Capability<T> var1, @Nullable Direction var2);

    default public Direction getFacing() {
        return this.getMergeHelper().getHorizontalFacing();
    }

    default public Direction getFacingVertical() {
        return this.getMergeHelper().getVerticalFacing() == null ? Direction.SOUTH : this.getMergeHelper().getVerticalFacing();
    }

    default public Vec3 rotated(Vec3 pos) {
        return RotationUtil.rotate(pos, RotationUtil.getRotation(this.getMergeHelper().getVerticalFacing(), this.getMergeHelper().getHorizontalFacing()));
    }

    default public Vec3 rotated(Vec3 pos, Vec3 pivot) {
        return RotationUtil.rotate(pos, RotationUtil.getRotation(this.getMergeHelper().getVerticalFacing(), this.getMergeHelper().getHorizontalFacing()), pivot);
    }

    default public JSGAxisAlignedBB rotated(JSGAxisAlignedBB box, Vec3 pivot) {
        return box.rotate(this.getMergeHelper().getHorizontalFacing(), this.getMergeHelper().getVerticalFacing(), pivot);
    }

    default public BlockPos rotated(BlockPos pos) {
        return RotationUtil.rotate(pos, RotationUtil.getRotation(this.getMergeHelper().getVerticalFacing(), this.getMergeHelper().getHorizontalFacing()));
    }

    default public BlockPos rotated(BlockPos pos, BlockPos pivot) {
        return RotationUtil.rotate(pos, RotationUtil.getRotation(this.getMergeHelper().getVerticalFacing(), this.getMergeHelper().getHorizontalFacing()), pivot);
    }

    default public JSGAxisAlignedBB relative(JSGAxisAlignedBB box, Vec3 pivot) {
        BlockPos p = this.blockPosition();
        return this.rotated(box, pivot).offset(p.m_123341_(), p.m_123342_(), p.m_123343_());
    }

    default public Vec3 relative(Vec3 pos, Vec3 pivot) {
        BlockPos p = this.blockPosition();
        return this.rotated(pos, pivot).m_82520_((double)p.m_123341_(), (double)p.m_123342_(), (double)p.m_123343_());
    }

    default public Vec3 relative(Vec3 pos) {
        BlockPos p = this.blockPosition();
        return this.rotated(pos).m_82520_((double)p.m_123341_(), (double)p.m_123342_(), (double)p.m_123343_());
    }

    default public BlockPos relative(BlockPos pos) {
        Vec3 vec3 = this.relative(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
        return new BlockPos((int)vec3.m_7096_(), (int)vec3.m_7098_(), (int)vec3.m_7094_());
    }

    default public BlockPos relative(BlockPos pos, BlockPos pivot) {
        BlockPos p = this.blockPosition();
        return this.rotated(pos, pivot).m_7918_(p.m_123341_(), p.m_123342_(), p.m_123343_());
    }

    default public Vec3 getRelative(Vec3 vector) {
        BlockPos p = this.blockPosition();
        return this.getRelativeRotated(vector.m_82492_((double)p.m_123341_(), (double)p.m_123342_(), (double)p.m_123343_()));
    }

    default public Vec3 getRelativeRotated(Vec3 vector) {
        Quaternionf rotationToRelative = RotationUtil.getRotationToZero(this.getMergeHelper().getVerticalFacing(), this.getMergeHelper().getHorizontalFacing());
        return RotationUtil.rotate(vector, rotationToRelative);
    }

    default public ItemStack getDropBaseBlock(ServerPlayer player) {
        ItemStack stack = new ItemStack((ItemLike)this.getStargateType().getBaseBlock());
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_("stargateEnergyManager", this.getEnergyManager().serializeNBT());
        stack.m_41751_(tag);
        return stack;
    }

    default public void updateContainerItemsByItemStack(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("stargateEnergyManager")) {
            return;
        }
        this.getEnergyManager().deserializeNBT((Tag)tag.m_128469_("stargateEnergyManager"));
        this.setStargateChanged();
    }
}

