/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.stargate.network.address.symbol;

import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class SymbolUtil {
    @NotNull
    public static SymbolInterface getSymbolFromNameIndexOrThrow(AbstractSymbolType<?> symbolType, Object nameIndex) throws IllegalArgumentException {
        SymbolInterface symbol = SymbolUtil.getSymbolFromNameIndex(symbolType, nameIndex);
        if (symbol == null) {
            throw new IllegalArgumentException("bad argument (symbol name/index invalid) (tried: " + String.valueOf(nameIndex) + ")");
        }
        return symbol;
    }

    @Nullable
    public static SymbolInterface getSymbolFromNameIndex(AbstractSymbolType<?> symbolType, Object nameIndex) {
        SymbolInterface symbol = null;
        if (nameIndex instanceof Integer) {
            symbol = (SymbolInterface)symbolType.valueOf((Integer)nameIndex);
        } else if (nameIndex instanceof Double) {
            symbol = (SymbolInterface)symbolType.valueOf(((Double)nameIndex).intValue());
        } else if (nameIndex instanceof String) {
            symbol = (SymbolInterface)symbolType.fromEnglishName((String)nameIndex);
        } else if (nameIndex instanceof byte[]) {
            symbol = (SymbolInterface)symbolType.fromEnglishName(new String((byte[])nameIndex));
        }
        if (symbol == null) {
            symbol = (SymbolInterface)symbolType.fromEnglishName(nameIndex.toString());
        }
        return symbol;
    }
}

