/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.stargate.network.address.symbol.types;

import dev.tauri.jsg.api.client.LoadersHolder;
import dev.tauri.jsg.api.client.model.IModelLoader;
import dev.tauri.jsg.api.client.screen.ITab;
import dev.tauri.jsg.api.client.screen.ITabAddress;
import dev.tauri.jsg.api.client.texture.ITextureLoader;
import dev.tauri.jsg.api.pointoforigins.IPointOfOriginType;
import dev.tauri.jsg.api.stargate.network.address.IAddress;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolUsage;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractSymbolType<T extends SymbolInterface> {
    public static AbstractSymbolType<?> byId(int id) {
        return SymbolTypeRegistry.byId(id);
    }

    public static AbstractSymbolType<?> byId(String id) {
        return SymbolTypeRegistry.byId(id);
    }

    public static int getId(AbstractSymbolType<?> type) {
        return SymbolTypeRegistry.getId(type);
    }

    public static AbstractSymbolType<?>[] values(@Nullable SymbolUsage usage) {
        return SymbolTypeRegistry.values(usage);
    }

    public String toString() {
        return this.getId();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof AbstractSymbolType)) {
            return false;
        }
        AbstractSymbolType s = (AbstractSymbolType)o;
        return Objects.equals(s.getId(), this.getId());
    }

    public boolean hasOrigin() {
        return this.getOrigin() != null;
    }

    public abstract int[] getAncientTitlePos();

    @OnlyIn(value=Dist.CLIENT)
    public abstract ITab.ITabBuilder finalizeAddressTab(ITab.ITabBuilder var1);

    @OnlyIn(value=Dist.CLIENT)
    public abstract ITabAddress.SymbolCoords getSymbolCoords(int var1);

    public abstract T[] getValues();

    public abstract Block getBaseBlock();

    public abstract Item getGlyphUpgrade();

    public abstract Block getDHDBlock();

    public abstract String getId();

    public abstract T getBRB();

    public abstract int getIconWidth();

    public abstract int getIconHeight();

    public abstract T getRandomSymbol(Random var1);

    public abstract T getOrigin();

    public abstract int getMaxSymbolsDisplay(boolean var1);

    public abstract int getMinimalSymbolCountTo(AbstractSymbolType<?> var1, boolean var2);

    public abstract boolean validateDialedAddress(IAddress var1);

    public abstract float getAnglePerGlyph();

    public float getAngleByAngIndex(int index) {
        return index;
    }

    public float getAngleOfNearest(float angle) {
        return 0.0f;
    }

    public abstract T getSymbolByAngle(float var1, float var2);

    public T getSymbolByAngle(float angle) {
        return this.getSymbolByAngle(angle, 360.0f);
    }

    public abstract T getTopSymbol();

    public abstract T valueOf(int var1);

    public abstract T fromEnglishName(String var1);

    public abstract T getFirstValidForAddress();

    public ITextureLoader getTextureLoader() {
        return LoadersHolder.JSG_HOLDER.texture();
    }

    public IModelLoader getModelLoader() {
        return LoadersHolder.JSG_HOLDER.model();
    }

    public abstract IPointOfOriginType getPointOfOriginType();
}

