/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.stargate.traveler;

import dev.tauri.jsg.api.stargate.Stargate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;

public interface IStargateTraveler<E> {
    public E get();

    public Stargate<?> getTransmitter();

    public Stargate<?> getReceiver();

    public Vec3 getOriginalMotion();

    public Vec3 getDestinationMotion();

    public void setMotion(Vec3 var1);

    public Vec3 getOriginalPos();

    public Vec3 getDestinationPos();

    public void setPos(Vec3 var1);

    public void setYaw(float var1);

    public float getDestinationYaw();

    default public boolean isSameDimension() {
        return this.getTransmitter().getStargatePos() != null && this.getReceiver().getStargatePos() != null && this.getTransmitter().getStargatePos().dimension == this.getReceiver().getStargatePos().dimension;
    }

    default public boolean isPlayer() {
        return false;
    }

    default public boolean isStatic() {
        return false;
    }

    default public boolean canBeKilledByIris() {
        return true;
    }

    default public void place() {
        this.setPos(this.getDestinationPos());
        this.setYaw(this.getDestinationYaw());
        this.setMotion(this.getDestinationMotion());
    }

    default public boolean canBeSendThisWay(boolean rightWay) {
        return rightWay;
    }

    default public boolean canBeSendToTarget() {
        return true;
    }

    public void sendChangeDimension(ServerLevel var1);

    default public void sendSameDimension() {
        this.getReceiver().getEventHorizonManager().receive(this);
    }

    default public void send() {
        if (!this.isStatic() && !this.getTransmitter().getEventHorizonManager().canBeSend(this)) {
            return;
        }
        if (!this.isSameDimension()) {
            this.sendChangeDimension((ServerLevel)this.getReceiver().getStargateLevel());
        } else {
            this.sendSameDimension();
        }
    }

    public void killWrongTravel();

    public void killIris();

    public void killKawoosh();

    public void killUnstable();

    public int hashCode();

    public boolean equals(Object var1);
}

