/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.stargate.type;

import dev.tauri.jsg.api.config.ingame.option.ConfigOptionsHolder;
import dev.tauri.jsg.api.pointoforigins.IPointOfOriginType;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.stargate.type.StargateTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class StargateType
implements IPointOfOriginType {
    private static final Map<Integer, StargateType> REGISTRY = new HashMap<Integer, StargateType>();
    private static final Map<String, StargateType> REGISTRY_STRING = new HashMap<String, StargateType>();
    private static int nextId = 0;
    public final int id = nextId++;
    public final String textId;
    public final String name;
    public final AbstractSymbolType<?> symbolType;
    public final Supplier<Block> baseBlockSupplier;
    @Nullable
    public final Supplier<Block> dhdBlockSupplier;
    public final Class<? extends BlockEntity> baseBlockEntityClass;
    public final Supplier<ConfigOptionsHolder> configOptionsHolder;
    public final boolean isClassic;
    public final List<String> pooModelsTypes;
    public final List<String> pooTexturesTypes;
    public final List<ResourceLocation> defaultPointOfOrigins;

    public StargateType(String textId, String name, AbstractSymbolType<?> symbolType, Class<? extends BlockEntity> baseBlockEntityClass, Supplier<Block> baseBlockSupplier, @Nullable Supplier<Block> dhdBlockSupplier, @Nonnull Supplier<ConfigOptionsHolder> configOptionsHolder, boolean isClassic, List<String> pooModelsTypes, List<String> pooTexturesTypes, List<ResourceLocation> defaultPointOfOrigins) {
        this.textId = textId.toLowerCase();
        this.name = name;
        this.symbolType = symbolType;
        this.baseBlockEntityClass = baseBlockEntityClass;
        this.baseBlockSupplier = baseBlockSupplier;
        this.dhdBlockSupplier = dhdBlockSupplier;
        this.configOptionsHolder = configOptionsHolder;
        this.isClassic = isClassic;
        this.defaultPointOfOrigins = defaultPointOfOrigins;
        this.pooModelsTypes = pooModelsTypes;
        this.pooTexturesTypes = pooTexturesTypes;
        REGISTRY.put(this.id, this);
        REGISTRY_STRING.put(this.textId, this);
        REGISTRY_STRING.put(this.name.toLowerCase(), this);
    }

    public String getId() {
        return this.textId;
    }

    public String toString() {
        return this.name;
    }

    public Block getBaseBlock() {
        return this.baseBlockSupplier.get();
    }

    public Block getDHDBlock() {
        if (this.dhdBlockSupplier == null) {
            return null;
        }
        return this.dhdBlockSupplier.get();
    }

    public static StargateType valueOf(int id) {
        return REGISTRY.get(id);
    }

    public static StargateType valueOf(String id) {
        return REGISTRY_STRING.get(id.toLowerCase());
    }

    public static Collection<StargateType> values() {
        return REGISTRY.values();
    }

    @Nullable
    public static StargateType getRandom(RandomSource random) {
        if (REGISTRY.isEmpty()) {
            return null;
        }
        return new ArrayList<StargateType>(REGISTRY.values()).get(random.m_188503_(REGISTRY.size()));
    }

    @Nullable
    public static StargateType getRandomClassic(RandomSource random) {
        for (int i = 0; i < 100; ++i) {
            StargateType r = StargateType.getRandom(random);
            if (r != null) continue;
            return null;
        }
        return null;
    }

    public static StargateType parse(AbstractSymbolType<?> type) {
        if (type == SymbolTypeRegistry.MILKYWAY) {
            return StargateTypes.MILKYWAY;
        }
        if (type == SymbolTypeRegistry.PEGASUS) {
            return StargateTypes.PEGASUS;
        }
        if (type == SymbolTypeRegistry.UNIVERSE) {
            return StargateTypes.UNIVERSE;
        }
        return StargateTypes.MILKYWAY;
    }

    @Override
    public String getPoONamespaceIdentifier() {
        return "stargate/" + this.getId();
    }

    @Override
    public List<String> getPoOModelsTypes() {
        return this.pooModelsTypes;
    }

    @Override
    public List<String> getPoOTexturesTypes() {
        return this.pooTexturesTypes;
    }

    @Override
    public List<ResourceLocation> getPoODefaults() {
        return this.defaultPointOfOrigins;
    }
}

