/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.state;

import dev.tauri.jsg.api.state.State;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class StateType {
    private static final Map<Integer, StateType> ID_MAP = new HashMap<Integer, StateType>();
    private static int currentId = 0;
    public static final StateType RENDERER_STATE = StateType.create("renderer_state");
    public static final StateType GUI_STATE = StateType.create("gui_state");
    public static final StateType GUI_UPDATE = StateType.create("gui_update");
    public static final StateType CAMO_STATE = StateType.create("camo_state");
    public static final StateType SPIN_STATE = StateType.create("spin_state");
    public static final StateType FLASH_STATE = StateType.create("flash_state");
    public static final StateType DHD_ACTIVATE_BUTTON = StateType.create("dhd_activate_button");
    public static final StateType RENDERER_UPDATE = StateType.create("renderer_update");
    public static final StateType IRIS_ANIMATION = StateType.create("iris_animation");
    public static final StateType STARGATE_VAPORIZE_BLOCK_PARTICLES = StateType.create("gate_vapor_block_particles");
    public static final StateType BIOME_OVERRIDE_STATE = StateType.create("biome_override_state");
    public static final StateType BLACK_HOLE_ANIMATION_UPDATE = StateType.create("black_hole_update");
    public static final StateType CHEVRONS_STATE = StateType.create("chevrons_state");
    public static final StateType SOUND_UPDATE = StateType.create("sound_update_state");
    public static final StateType ORLIN_PARTICLE_STATE = StateType.create("orlin_particle_state");
    public final int id = currentId++;
    public final ResourceLocation name;

    public static StateType byId(int id) {
        return ID_MAP.get(id);
    }

    public StateType(ResourceLocation name) {
        this.name = name;
        ID_MAP.put(this.id, this);
    }

    public String name() {
        return this.name.toString();
    }

    public String toString() {
        return this.name();
    }

    public boolean is(StateType otherStateType) {
        return this.id == otherStateType.id;
    }

    public StateExecutor stateExecutor() {
        return new StateExecutor(this);
    }

    public StateSupplier stateSupplier() {
        return new StateSupplier(this);
    }

    public boolean equals(Object other) {
        if (!(other instanceof StateType)) {
            return false;
        }
        StateType otherStateType = (StateType)other;
        return this.is(otherStateType);
    }

    public int hashCode() {
        return this.id * 31;
    }

    public static StateType create(ResourceLocation name) {
        return new StateType(name);
    }

    private static StateType create(String name) {
        return StateType.create(new ResourceLocation("jsg", name));
    }

    public static class StateExecutor {
        private Runnable result = null;
        private final StateType original;

        public StateExecutor(StateType original) {
            this.original = original;
        }

        public void run() {
            if (this.result != null) {
                this.result.run();
            }
        }

        public void runOrElse(Runnable defaultRunnable) {
            if (this.result == null) {
                defaultRunnable.run();
            } else {
                this.run();
            }
        }

        public StateExecutor tryType(StateType otherStateType, Runnable stateRunnable) {
            if (this.original.is(otherStateType)) {
                this.result = stateRunnable;
            }
            return this;
        }
    }

    public static class StateSupplier {
        private Supplier<State> result = null;
        private final StateType original;

        public StateSupplier(StateType original) {
            this.original = original;
        }

        @Nullable
        public State get() {
            return this.result.get();
        }

        public State orElseGet(Supplier<State> defaultSupplier) {
            if (this.result == null) {
                return defaultSupplier.get();
            }
            return this.result.get();
        }

        public State orElseThrow(Object caller) {
            if (this.result == null) {
                throw new UnsupportedOperationException("EnumStateType." + this.original.name() + " not implemented on " + caller.getClass().getName());
            }
            return this.result.get();
        }

        public StateSupplier tryType(StateType otherStateType, Supplier<State> stateSupplier) {
            if (this.original.is(otherStateType)) {
                this.result = stateSupplier;
            }
            return this;
        }
    }
}

