/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.util;

import dev.tauri.jsg.api.blockstates.JSGProperties;
import dev.tauri.jsg.api.util.JSGAxisAlignedBB;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;

public class RotationUtil {
    public static double getClosestAngleDistance(double angle1, double angle2, boolean radians) {
        double round;
        double d = round = radians ? Math.PI : 360.0;
        while (angle1 < 0.0) {
            angle1 += round;
        }
        while (angle2 < 0.0) {
            angle2 += round;
        }
        double diffAngle = Math.abs((angle2 %= round) - (angle1 %= round));
        if (diffAngle > round / 2.0) {
            diffAngle = round - diffAngle;
        }
        return diffAngle;
    }

    public static BlockPos rotate(BlockPos pos, Quaternionf rotation) {
        return RotationUtil.rotate(pos, rotation, BlockPos.f_121853_);
    }

    public static BlockPos rotate(BlockPos pos, Quaternionf rotation, BlockPos pivot) {
        Vec3 v = RotationUtil.rotate(new Vec3((double)(pos.m_123341_() - pivot.m_123341_()), (double)(pos.m_123342_() - pivot.m_123342_()), (double)(pos.m_123343_() - pivot.m_123343_())), rotation);
        return new BlockPos((int)v.f_82479_ + pivot.m_123341_(), (int)v.f_82480_ + pivot.m_123342_(), (int)v.f_82481_ + pivot.m_123343_());
    }

    public static AABB rotate(AABB box, Quaternionf rotation) {
        return RotationUtil.rotate(box, rotation, new Vec3(0.0, 0.0, 0.0));
    }

    public static AABB rotate(AABB box, Quaternionf rotation, Vec3 pivot) {
        Vec3 p1 = RotationUtil.rotate(new Vec3(box.f_82288_, box.f_82289_, box.f_82290_).m_82546_(pivot), rotation);
        Vec3 p2 = RotationUtil.rotate(new Vec3(box.f_82291_, box.f_82292_, box.f_82293_).m_82546_(pivot), rotation);
        return new AABB(p1.f_82479_, p1.f_82480_, p1.f_82481_, p2.f_82479_, p2.f_82480_, p2.f_82481_).m_82383_(pivot);
    }

    public static JSGAxisAlignedBB rotate(JSGAxisAlignedBB box, Quaternionf rotation) {
        return RotationUtil.rotate(box, rotation, new Vec3(0.0, 0.0, 0.0));
    }

    public static JSGAxisAlignedBB rotate(JSGAxisAlignedBB box, Quaternionf rotation, Vec3 pivot) {
        Vec3 p1 = RotationUtil.rotate(new Vec3(box.f_82288_, box.f_82289_, box.f_82290_).m_82546_(pivot), rotation);
        Vec3 p2 = RotationUtil.rotate(new Vec3(box.f_82291_, box.f_82292_, box.f_82293_).m_82546_(pivot), rotation);
        return new JSGAxisAlignedBB(p1.f_82479_, p1.f_82480_, p1.f_82481_, p2.f_82479_, p2.f_82480_, p2.f_82481_).offset(pivot);
    }

    public static Vec3 rotate(Vec3 vec3, Quaternionf rotation) {
        return RotationUtil.rotate(vec3, rotation, new Vec3(0.0, 0.0, 0.0));
    }

    public static Vec3 rotate(Vec3 vec3, Quaternionf rotation, Vec3 pivot) {
        Vector3d q = rotation.normalize().transform(new Vector3d(vec3.f_82479_ - pivot.f_82479_, vec3.f_82480_ - pivot.f_82480_, vec3.f_82481_ - pivot.f_82481_));
        return new Vec3(q.x, q.y, q.z).m_82549_(pivot);
    }

    public static Quaternionf getRotation(BlockState blockState) {
        return RotationUtil.getRotation(JSGProperties.getDirectionByVerticalFacing(blockState.m_61145_((Property)JSGProperties.FACING_VERTICAL_PROPERTY).orElse(0)), blockState.m_61145_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY).orElse(Direction.SOUTH));
    }

    public static Quaternionf getRotation(Direction verticalFacing, Direction horizontalFacing) {
        Quaternionf h = horizontalFacing.m_253075_();
        if (verticalFacing != Direction.UP && verticalFacing != Direction.DOWN) {
            return h.mul((Quaternionfc)Direction.SOUTH.m_253075_().rotateX((float)Math.PI));
        }
        return h.mul((Quaternionfc)verticalFacing.m_253075_().rotateX((float)Math.PI));
    }

    public static Quaternionf getRotationToZero(Direction verticalFacing, Direction horizontalFacing) {
        return RotationUtil.getRotation(verticalFacing == null ? Direction.NORTH : verticalFacing.m_122424_(), horizontalFacing.m_122424_()).invert();
    }

    public static Vec3 yawToVector(float yaw) {
        float rad = (float)Math.toRadians(-yaw);
        double x = Math.sin(rad);
        double z = Math.cos(rad);
        return new Vec3(x, 0.0, z);
    }

    public static float vectorToYaw(Vec3 v) {
        return (float)Math.toDegrees(Math.atan2(-v.f_82479_, v.f_82481_));
    }
}

