/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.block;

import dev.tauri.jsg.api.block.util.IItemBlock;
import dev.tauri.jsg.api.item.ITabbedItem;
import dev.tauri.jsg.api.item.JSGBlockItem;
import dev.tauri.jsg.item.LemonItem;
import dev.tauri.jsg.registry.tags.JSGBlockTags;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LemonBlock
extends FallingBlock
implements ITabbedItem,
IItemBlock {
    public LemonBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56758_).m_60977_().m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61405_, (Comparable)Integer.valueOf(0))).m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return null;
    }

    @ParametersAreNonnullByDefault
    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        pLevel.m_186460_(pPos, (Block)this, 1);
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61405_});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    @ParametersAreNonnullByDefault
    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (this.canDropAndUpdateShape((Level)pLevel, pPos, pState, true) && pPos.m_123342_() >= pLevel.m_141937_()) {
            this.m_6788_(FallingBlockEntity.m_201971_((Level)pLevel, (BlockPos)pPos, (BlockState)((BlockState)pState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN))));
        }
    }

    @ParametersAreNonnullByDefault
    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pRandom.m_188503_(16) == 0 && this.canDropAndUpdateShape(pLevel, pPos, pState, false)) {
            ParticleUtils.m_272037_((Level)pLevel, (BlockPos)pPos, (RandomSource)pRandom, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, pState));
        }
    }

    public boolean canDropAndUpdateShape(Level level, BlockPos pos, BlockState state, boolean updateShape) {
        BlockState bellow;
        if (!state.m_61138_((Property)BlockStateProperties.f_61405_) || (Integer)state.m_61143_((Property)BlockStateProperties.f_61405_) < 1) {
            Optional dirOpt = state.m_61145_((Property)BlockStateProperties.f_61372_);
            if (dirOpt.isPresent() && dirOpt.get() != Direction.DOWN) {
                if (level.m_8055_(pos.m_121945_((Direction)dirOpt.get())).m_204336_(JSGBlockTags.SUPPORT_LEMON)) {
                    return false;
                }
            } else {
                for (Direction dir : Direction.values()) {
                    if (dir == Direction.DOWN || !level.m_8055_(pos.m_121945_(dir)).m_204336_(JSGBlockTags.SUPPORT_LEMON)) continue;
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)dir), 3);
                    return false;
                }
            }
        }
        return (bellow = level.m_8055_(pos.m_7495_())).m_60795_() || bellow.m_204336_(BlockTags.f_13076_) || bellow.m_278721_() || bellow.m_247087_();
    }

    @ParametersAreNonnullByDefault
    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!(pLevel.f_46443_ || pState.m_61138_((Property)BlockStateProperties.f_61405_) && (Integer)pState.m_61143_((Property)BlockStateProperties.f_61405_) >= 1 || !(pRandom.m_188501_() < 0.3f))) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)BlockStateProperties.f_61405_, (Comparable)Integer.valueOf(1)), 3);
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        pLevel.m_186460_(pCurrentPos, (Block)this, 1);
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        Direction facing = blockState.m_61145_((Property)BlockStateProperties.f_61372_).orElse(Direction.DOWN);
        if (facing == Direction.DOWN) {
            return Shapes.m_166049_((double)0.4, (double)0.0, (double)0.3, (double)0.6, (double)0.3, (double)0.7);
        }
        if (facing == Direction.UP) {
            return Shapes.m_166049_((double)0.3, (double)0.5, (double)0.3, (double)0.7, (double)1.0, (double)0.7);
        }
        Vec3i vec = facing.m_122436_();
        return Shapes.m_166049_((double)0.3, (double)0.0, (double)0.3, (double)0.7, (double)1.0, (double)0.7).m_83216_((double)((float)vec.m_123341_() * 0.3f), 0.0, (double)((float)vec.m_123343_() * 0.3f));
    }

    @Override
    public JSGBlockItem getItemBlock() {
        return new LemonItem((Block)this);
    }
}

