/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.block.cartouche;

import dev.tauri.jsg.api.util.JSGAxisAlignedBB;
import dev.tauri.jsg.block.cartouche.CartoucheBlock;
import dev.tauri.jsg.loader.ElementEnum;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public enum CartoucheType {
    SIX("six_symbol_", ElementEnum.CARTOUCHE_PLATE_6, 6, false, 2),
    SEVEN("seven_symbol_", ElementEnum.CARTOUCHE_PLATE_7, 7, false, 2),
    EIGHT("eight_symbol_", ElementEnum.CARTOUCHE_PLATE_8, 8, false, 3),
    SEVEN_POO("seven_symbol_", "_with_origin", ElementEnum.CARTOUCHE_PLATE_7_POO, 6, true, 3),
    EIGHT_POO("eight_symbol_", "_with_origin", ElementEnum.CARTOUCHE_PLATE_8_POO, 7, true, 3),
    NINE_POO("nine_symbol_", "_with_origin", ElementEnum.CARTOUCHE_PLATE_9_POO, 8, true, 3);

    public final String prefix;
    public final String suffix;
    public final ElementEnum model;
    public final boolean hasPoo;
    public final int symbolsCount;
    public final int height;

    private CartoucheType(String prefix, ElementEnum model, int symbolsCount, boolean hasPoo, int height) {
        this(prefix, "", model, symbolsCount, hasPoo, height);
    }

    private CartoucheType(String prefix, String suffix, ElementEnum model, int symbolsCount, boolean hasPoo, int height) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.model = model;
        this.symbolsCount = symbolsCount;
        this.hasPoo = hasPoo;
        this.height = height;
    }

    public JSGAxisAlignedBB box(boolean renderBox) {
        JSGAxisAlignedBB box = new JSGAxisAlignedBB(0.15, 0.0, 0.0, 0.85, 1.0, 0.1);
        if (!renderBox) {
            return box;
        }
        return box.grow(0.0, this.height - 1, 0.0);
    }

    public static Map<CartoucheType, RegistryObject<Block>> registerTypes(Supplier<DeferredRegister<Block>> register, String baseName, Supplier<BlockState> material) {
        HashMap<CartoucheType, RegistryObject<Block>> map = new HashMap<CartoucheType, RegistryObject<Block>>();
        for (CartoucheType t : CartoucheType.values()) {
            map.put(t, (RegistryObject<Block>)register.get().register(t.prefix + baseName + t.suffix, () -> new CartoucheBlock(material, t)));
        }
        return map;
    }
}

