/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.block.cauldron;

import dev.tauri.jsg.block.cauldron.JSGFluidCauldron;
import dev.tauri.jsg.helpers.FluidHelper;
import dev.tauri.jsg.helpers.ItemHandlerHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;

public abstract class CauldronRecipe {
    public static final List<CauldronRecipe> RECIPES = new ArrayList<CauldronRecipe>();
    protected Map<Item, CauldronInteraction> baseFluidIntercationMap;

    public CauldronRecipe() {
        RECIPES.add(this);
    }

    public CauldronRecipe setRecipeHandler(Map<Item, CauldronInteraction> recipeHandler) {
        this.baseFluidIntercationMap = recipeHandler;
        return this;
    }

    public abstract void insertInteractions();

    public static InteractionResult fillBucket(BlockState pBlockState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, ItemStack pEmptyStack, ItemStack pFilledStack, Predicate<BlockState> pStatePredicate, SoundEvent pFillSound) {
        if (!pStatePredicate.test(pBlockState)) {
            return InteractionResult.PASS;
        }
        if (!pLevel.f_46443_) {
            Item item = pEmptyStack.m_41720_();
            pPlayer.m_21008_(pHand, ItemUtils.m_41813_((ItemStack)pEmptyStack, (Player)pPlayer, (ItemStack)pFilledStack));
            pPlayer.m_36220_(Stats.f_12944_);
            pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            pLevel.m_46597_(pPos, Blocks.f_50256_.m_49966_());
            pLevel.m_5594_(null, pPos, pFillSound, SoundSource.BLOCKS, 1.0f, 1.0f);
            pLevel.m_142346_(null, GameEvent.f_157816_, pPos);
        }
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    public static InteractionResult emptyBucket(Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, ItemStack pFilledStack, BlockState pState, SoundEvent pEmptySound) {
        if (!pLevel.f_46443_) {
            Item item = pFilledStack.m_41720_();
            pPlayer.m_21008_(pHand, ItemUtils.m_41813_((ItemStack)pFilledStack, (Player)pPlayer, (ItemStack)new ItemStack((ItemLike)Items.f_42446_)));
            pPlayer.m_36220_(Stats.f_12943_);
            pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            pLevel.m_46597_(pPos, pState);
            pLevel.m_5594_(null, pPos, pEmptySound, SoundSource.BLOCKS, 1.0f, 1.0f);
            pLevel.m_142346_(null, GameEvent.f_157769_, pPos);
        }
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    public static class CauldronGenericRecipes
    extends CauldronRecipe {
        private final FluidHelper.MoltenFluid forFluid;

        public CauldronGenericRecipes(FluidHelper.MoltenFluid forFluid) {
            this.forFluid = forFluid;
            this.setRecipeHandler(forFluid.cauldronInteractionMap);
        }

        @Override
        public void insertInteractions() {
            CauldronInteraction.f_175606_.put((Item)this.forFluid.bucket.get(), (pBlockState, pLevel, pBlockPos, pPlayer, pHand, pStack) -> CauldronGenericRecipes.emptyBucket(pLevel, pBlockPos, pPlayer, pHand, pStack, ((JSGFluidCauldron)((Object)((Object)this.forFluid.cauldron.get()))).m_49966_(), SoundEvents.f_11780_));
            CauldronInteraction.f_175608_.put((Item)this.forFluid.bucket.get(), (pBlockState, pLevel, pBlockPos, pPlayer, pHand, pStack) -> CauldronGenericRecipes.emptyBucket(pLevel, pBlockPos, pPlayer, pHand, pStack, ((JSGFluidCauldron)((Object)((Object)this.forFluid.cauldron.get()))).m_49966_(), SoundEvents.f_11780_));
            CauldronInteraction.f_175607_.put((Item)this.forFluid.bucket.get(), (pBlockState, pLevel, pBlockPos, pPlayer, pHand, pStack) -> CauldronGenericRecipes.emptyBucket(pLevel, pBlockPos, pPlayer, pHand, pStack, ((JSGFluidCauldron)((Object)((Object)this.forFluid.cauldron.get()))).m_49966_(), SoundEvents.f_11780_));
            CauldronInteraction.m_175647_((Map)this.baseFluidIntercationMap);
            this.baseFluidIntercationMap.put(Items.f_42446_, (pBlockState, pLevel, pBlockPos, pPlayer, pHand, pStack) -> CauldronGenericRecipes.fillBucket(pBlockState, pLevel, pBlockPos, pPlayer, pHand, pStack, new ItemStack((ItemLike)this.forFluid.bucket.get()), state -> true, SoundEvents.f_11783_));
        }
    }

    public static class CauldronBathingRecipe
    extends CauldronRecipe
    implements ItemResult {
        private Supplier<Item> itemToBath;
        private Supplier<ItemStack> drop;
        private Supplier<Fluid> baseFluid;

        public CauldronBathingRecipe setItemToBath(Supplier<Item> itemToBath) {
            this.itemToBath = itemToBath;
            return this;
        }

        public CauldronBathingRecipe setDrop(Supplier<ItemStack> drop) {
            this.drop = drop;
            return this;
        }

        public CauldronBathingRecipe setBaseFluid(Supplier<Fluid> baseFluid) {
            this.baseFluid = baseFluid;
            return this;
        }

        @Override
        public void insertInteractions() {
            this.baseFluidIntercationMap.put(this.itemToBath.get(), (pBlockState, pLevel, pBlockPos, pPlayer, pHand, pStack) -> {
                if (!pLevel.f_46443_) {
                    Item item = pStack.m_41720_();
                    pStack.m_41774_(1);
                    pPlayer.m_36220_(Stats.f_12944_);
                    pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                    pLevel.m_5594_(null, pBlockPos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    pLevel.m_142346_(null, GameEvent.f_157792_, pBlockPos);
                    ItemHandlerHelper.spawnItemStack(pLevel, pBlockPos.m_7494_(), this.drop.get());
                }
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            });
        }

        @Override
        public Supplier<Item> getItemInput() {
            return this.itemToBath;
        }

        @Override
        public Supplier<ItemStack> getItemResult() {
            return this.drop;
        }

        @Override
        public Supplier<Fluid> getItemBaseFluid() {
            return this.baseFluid;
        }
    }

    public static class CauldronCastingRecipe
    extends CauldronRecipe
    implements ItemResult {
        private Supplier<ItemStack> drop;
        private Supplier<Fluid> baseFluid;

        public CauldronCastingRecipe setDrop(Supplier<ItemStack> drop) {
            this.drop = drop;
            return this;
        }

        public CauldronCastingRecipe setBaseFluid(Supplier<Fluid> baseFluid) {
            this.baseFluid = baseFluid;
            return this;
        }

        @Override
        public void insertInteractions() {
            this.baseFluidIntercationMap.put(Blocks.f_50127_.m_5456_(), (pBlockState, pLevel, pBlockPos, pPlayer, pHand, pStack) -> {
                if (!pLevel.f_46443_) {
                    Item item = pStack.m_41720_();
                    pStack.m_41774_(1);
                    pPlayer.m_36220_(Stats.f_12944_);
                    pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                    pLevel.m_46597_(pBlockPos, Blocks.f_50256_.m_49966_());
                    pLevel.m_5594_(null, pBlockPos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    pLevel.m_142346_(null, GameEvent.f_157792_, pBlockPos);
                    ItemHandlerHelper.spawnItemStack(pLevel, pBlockPos.m_7494_(), this.drop.get());
                }
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            });
        }

        @Override
        public Supplier<Item> getItemInput() {
            return () -> ((Block)Blocks.f_50127_).m_5456_();
        }

        @Override
        public Supplier<ItemStack> getItemResult() {
            return this.drop;
        }

        @Override
        public Supplier<Fluid> getItemBaseFluid() {
            return this.baseFluid;
        }
    }

    public static class CauldronMixtureRecipe
    extends CauldronRecipe
    implements FluidResult {
        private Supplier<Item> itemToMelt;
        private Supplier<BlockState> newCauldronState;
        private Supplier<Fluid> newFluid;
        private Supplier<Fluid> baseFluid;

        public CauldronMixtureRecipe setItemToMelt(Supplier<Item> itemToMelt) {
            this.itemToMelt = itemToMelt;
            return this;
        }

        public CauldronMixtureRecipe setNewCauldronStateSupplier(Supplier<BlockState> newCauldronState) {
            this.newCauldronState = newCauldronState;
            return this;
        }

        public CauldronMixtureRecipe setNewFluid(Supplier<Fluid> newFluid) {
            this.newFluid = newFluid;
            return this;
        }

        public CauldronMixtureRecipe setBaseFluid(Supplier<Fluid> baseFluid) {
            this.baseFluid = baseFluid;
            return this;
        }

        @Override
        public void insertInteractions() {
            this.baseFluidIntercationMap.put(this.itemToMelt.get(), (pBlockState, pLevel, pBlockPos, pPlayer, pHand, pStack) -> {
                if (!pLevel.f_46443_) {
                    Item item = pStack.m_41720_();
                    pStack.m_41774_(1);
                    pPlayer.m_36220_(Stats.f_12944_);
                    pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                    pLevel.m_46597_(pBlockPos, this.newCauldronState.get());
                    pLevel.m_5594_(null, pBlockPos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    pLevel.m_142346_(null, GameEvent.f_157792_, pBlockPos);
                }
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            });
        }

        @Override
        public Supplier<Fluid> getFluidResult() {
            return this.newFluid;
        }

        @Override
        public Supplier<Item> getFluidInput() {
            return this.itemToMelt;
        }

        @Override
        public Supplier<Fluid> getFluidBaseFluid() {
            return this.baseFluid;
        }
    }

    public static interface FluidResult {
        public Supplier<Fluid> getFluidResult();

        public Supplier<Item> getFluidInput();

        public Supplier<Fluid> getFluidBaseFluid();
    }

    public static interface ItemResult {
        public Supplier<Item> getItemInput();

        public Supplier<ItemStack> getItemResult();

        public Supplier<Fluid> getItemBaseFluid();
    }
}

