/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.block.crystal;

import dev.tauri.jsg.block.crystal.CrystalBuddingBlock;
import dev.tauri.jsg.block.crystal.CrystalColor;
import dev.tauri.jsg.registry.tags.JSGItemTags;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class CrystalUnstableBuddingBlock
extends CrystalBuddingBlock {
    public final Supplier<Block> stableBudding;
    public final Supplier<BlockState> originalBlockSupplier;

    public CrystalUnstableBuddingBlock(CrystalColor color, BlockBehaviour.Properties properties, Supplier<Block> stableBudding, Supplier<BlockState> originalBlockSupplier) {
        super(color, properties);
        this.stableBudding = stableBudding;
        this.originalBlockSupplier = originalBlockSupplier;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61406_, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61406_});
    }

    @Override
    @ParametersAreNonnullByDefault
    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pLevel.f_46443_) {
            return;
        }
        if (pRandom.m_188503_(5) == 0) {
            this.growUp(pState, (Level)pLevel, pPos, pRandom, true);
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer.m_21120_(pHand).m_204117_(JSGItemTags.CRYSTAL_FERTILIZERS)) {
            if (!pLevel.f_46443_) {
                if (!pPlayer.m_7500_()) {
                    pPlayer.m_21120_(pHand).m_41774_(1);
                }
                this.growUp(pState, pLevel, pPos, pLevel.f_46441_, false);
                pLevel.m_5594_(null, pPos, SoundEvents.f_12446_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.m_19078_((boolean)true);
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    protected void growUp(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom, boolean chanceToDestroy) {
        if (chanceToDestroy && (double)pRandom.m_188501_() < 0.3) {
            pLevel.m_7731_(pPos, this.originalBlockSupplier.get(), 3);
            return;
        }
        BlockState state = pState.m_61145_((Property)BlockStateProperties.f_61406_).map(a -> a >= 2 ? this.stableBudding.get().m_49966_() : (BlockState)pState.m_61124_((Property)BlockStateProperties.f_61406_, (Comparable)Integer.valueOf(a + 1))).orElse(this.originalBlockSupplier.get());
        pLevel.m_7731_(pPos, state, 3);
    }
}

