/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.block.dialhomedevice;

import dev.tauri.jsg.api.block.util.IHighlightBlock;
import dev.tauri.jsg.api.block.util.IItemBlock;
import dev.tauri.jsg.api.blockstates.JSGProperties;
import dev.tauri.jsg.api.util.JSGAxisAlignedBB;
import dev.tauri.jsg.api.util.RotationUtil;
import dev.tauri.jsg.api.util.math.MathHelper;
import dev.tauri.jsg.block.TickableBEBlock;
import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.blockentity.util.ILinkable;
import dev.tauri.jsg.helpers.BlockPosHelper;
import dev.tauri.jsg.helpers.ItemHandlerHelper;
import dev.tauri.jsg.screen.inventory.dialhomedevice.DHDContainer;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public abstract class DHDAbstractBlock
extends TickableBEBlock
implements IHighlightBlock,
IItemBlock {
    protected static final BlockBehaviour.Properties DHD_PROPS = BlockBehaviour.Properties.m_284310_().m_155956_(30.0f).m_155954_(3.0f).m_60924_((state, getter, pos) -> true).m_60971_((state, getter, pos) -> false).m_60999_().m_60918_(SoundType.f_56743_).m_60955_();
    public static final BlockMatchTest SNOW_MATCHER = new BlockMatchTest(Blocks.f_50125_);

    public DHDAbstractBlock() {
        super(DHD_PROPS);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)JSGProperties.ROTATION_PROPERTY, (Comparable)Integer.valueOf(0))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)JSGProperties.ROTATION_PROPERTY, (Comparable)Integer.valueOf(BlockPosHelper.rotateDHDDir((Integer)blockState.m_61143_((Property)JSGProperties.ROTATION_PROPERTY), rotation)));
    }

    @Override
    public boolean renderHighlight(BlockState blockState) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (!level.f_46443_) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_));
            if (placer != null) {
                boolean snowy = DHDAbstractBlock.isSnowAroundBlock(level, pos);
                int facing = MathHelper.floor((double)(placer.m_6080_() * 16.0f / 360.0f) + 0.5) & 0xF;
                state = (BlockState)((BlockState)state.m_61124_((Property)JSGProperties.ROTATION_PROPERTY, (Comparable)Integer.valueOf(facing))).m_61124_((Property)JSGProperties.SNOWY, (Comparable)Boolean.valueOf(snowy));
                DHDAbstractBE dhdTile = (DHDAbstractBE)level.m_7702_(pos);
                Objects.requireNonNull(dhdTile).updateLinkStatus(level, pos);
            }
            level.m_7731_(pos, state, 3);
        }
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{JSGProperties.ROTATION_PROPERTY});
        builder.m_61104_(new Property[]{JSGProperties.SNOWY});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    @NotNull
    public FluidState m_5888_(BlockState p_152045_) {
        return (Boolean)p_152045_.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_152045_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public static boolean isSnowAroundBlock(Level world, BlockPos inPos) {
        for (Direction facing : JSGProperties.FACING_HORIZONTAL_PROPERTY.m_6908_()) {
            BlockPos pos = inPos.m_121955_(facing.m_122436_());
            if (SNOW_MATCHER.m_213865_(world.m_8055_(pos), world.f_46441_)) continue;
            return false;
        }
        return true;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        float dhdRot;
        boolean backActivation;
        if (level.f_46443_) {
            return InteractionResult.FAIL;
        }
        float playerRot = player.m_146908_();
        boolean bl = backActivation = RotationUtil.getClosestAngleDistance(playerRot, dhdRot = (float)((Integer)state.m_61143_((Property)JSGProperties.ROTATION_PROPERTY)).intValue() * 22.5f, false) >= 135.0;
        if (!backActivation || player.m_6144_()) {
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof DHDAbstractBE)) {
            return InteractionResult.FAIL;
        }
        DHDAbstractBE dhd = (DHDAbstractBE)blockEntity;
        if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)level, (BlockPos)pos, null)) {
            if (!level.m_5776_()) {
                level.m_5594_(null, pos, SoundEvents.f_11780_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (!dhd.tryInsertUpgrade(player, hand) && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)new SimpleMenuProvider((id, pInv, p) -> new DHDContainer(id, pInv, dhd), (Component)Component.m_237119_()), (BlockPos)pos);
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    @ParametersAreNonnullByDefault
    public void m_5707_(Level level, BlockPos pos, BlockState blockState, Player player) {
        BlockEntity blockEntity;
        super.m_5707_(level, pos, blockState, player);
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof DHDAbstractBE) {
            DHDAbstractBE dhdTile = (DHDAbstractBE)blockEntity;
            ItemHandlerHelper.dropInventoryItems(level, pos, (IItemHandler)dhdTile.getCapability(ForgeCapabilities.ITEM_HANDLER, null).resolve().get());
            Object object = dhdTile.getLinkedDevice();
            if (object instanceof ILinkable) {
                ILinkable linkable = (ILinkable)object;
                linkable.setLinkedDevice(null);
            }
        }
    }

    @ParametersAreNonnullByDefault
    public void m_7592_(Level level, BlockPos pos, Explosion explosion) {
        BlockEntity blockEntity;
        super.m_7592_(level, pos, explosion);
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof DHDAbstractBE) {
            DHDAbstractBE dhdTile = (DHDAbstractBE)blockEntity;
            ItemHandlerHelper.dropInventoryItems(level, pos, (IItemHandler)dhdTile.getCapability(ForgeCapabilities.ITEM_HANDLER, null).resolve().get());
            Object object = dhdTile.getLinkedDevice();
            if (object instanceof ILinkable) {
                ILinkable linkable = (ILinkable)object;
                linkable.setLinkedDevice(null);
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        int rotation = (int)((float)((Integer)blockState.m_61143_((Property)JSGProperties.ROTATION_PROPERTY)).intValue() * 22.5f);
        JSGAxisAlignedBB aabb = rotation % 90 == 0 ? new JSGAxisAlignedBB(-0.5, 0.0, -0.25, 0.5, 1.3, 0.25).rotate(rotation).offset(0.5, 0.0, 0.5) : new JSGAxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.3, 0.75);
        return Shapes.m_83064_((AABB)aabb);
    }

    @ParametersAreNonnullByDefault
    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }
}

