/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.block.jub;

import dev.tauri.jsg.block.TickableBEBlock;
import dev.tauri.jsg.capability.JSGCapabilities;
import dev.tauri.jsg.jub.JUBDevice;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public abstract class JUBDeviceBlock
extends TickableBEBlock {
    public JUBDeviceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity deviceBE;
        if (!level.f_46443_ && (deviceBE = level.m_7702_(pos)) != null) {
            Optional deviceCapOpt = deviceBE.getCapability(JSGCapabilities.JUST_UNIVERSAL_BUS).resolve();
            deviceCapOpt.ifPresent(deviceCap -> player.m_213846_((Component)Component.m_237113_((String)deviceCap.getBus().uuid.toString())));
        }
        return InteractionResult.SUCCESS;
    }

    @ParametersAreNonnullByDefault
    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        super.m_6402_(level, blockPos, blockState, livingEntity, itemStack);
        level.m_46717_(blockPos, (Block)this);
    }

    public void onNeighborChange(BlockState state, LevelReader reader, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, reader, pos, neighbor);
        if (!(reader instanceof Level)) {
            return;
        }
        Level level = (Level)reader;
        if (level.m_5776_()) {
            return;
        }
        BlockEntity deviceBE = level.m_7702_(pos);
        if (deviceBE == null) {
            return;
        }
        Optional deviceCapOpt = deviceBE.getCapability(JSGCapabilities.JUST_UNIVERSAL_BUS).resolve();
        if (deviceCapOpt.isEmpty()) {
            return;
        }
        JUBDevice deviceCap = (JUBDevice)deviceCapOpt.get();
        deviceCap.updateBusDevices(level, neighbor);
    }
}

