/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.block.stargate;

import dev.tauri.jsg.api.block.stargate.IStargateBlock;
import dev.tauri.jsg.api.block.util.IHighlightBlock;
import dev.tauri.jsg.api.block.util.WrenchRotatable;
import dev.tauri.jsg.api.blockstates.JSGProperties;
import dev.tauri.jsg.block.TickableBEBlock;
import dev.tauri.jsg.block.stargate.StargateAbstractBaseBlock;
import dev.tauri.jsg.blockentity.CamouflageBE;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractMemberBE;
import dev.tauri.jsg.helpers.BlockPosHelper;
import dev.tauri.jsg.helpers.ItemHelper;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class StargateAbstractMemberBlock
extends TickableBEBlock
implements IStargateBlock,
IHighlightBlock,
SimpleWaterloggedBlock,
WrenchRotatable {
    protected static final BlockBehaviour.Properties STARGATE_MEMBER_PROPS = BlockBehaviour.Properties.m_284310_().m_60913_(2.5f, 30.0f).m_60924_((state, getter, pos) -> true).m_60971_((state, getter, pos) -> false).m_60955_().m_60999_().m_278166_(PushReaction.BLOCK).m_60918_(SoundType.f_56743_);

    public StargateAbstractMemberBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)JSGProperties.RENDER_BLOCK_PROPERTY, (Comparable)Boolean.valueOf(true))).m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)Direction.NORTH)).m_61124_((Property)JSGProperties.FACING_VERTICAL_PROPERTY, (Comparable)Integer.valueOf(0))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)BlockPosHelper.rotateDir((Direction)blockState.m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY), rotation));
    }

    @Override
    public void onWrenchUse(BlockState state, UseOnContext context) {
        StargateAbstractMemberBE member;
        StargateAbstractBaseBE<?, ?> gate;
        BlockEntity be = context.m_43725_().m_7702_(context.m_8083_());
        if (be instanceof StargateAbstractMemberBE && (gate = (member = (StargateAbstractMemberBE)be).getBaseTile(context.m_43725_())) != null) {
            if (gate.isMerged()) {
                return;
            }
            Direction facing = gate.getFacing();
            Direction vertical = gate.getFacingVertical();
            Pair<Direction, Direction> next = StargateAbstractBaseBlock.getNextDirections(facing, vertical);
            state = (BlockState)((BlockState)state.m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)((Direction)next.left()))).m_61124_((Property)JSGProperties.FACING_VERTICAL_PROPERTY, (Comparable)Integer.valueOf(JSGProperties.getVerticalFacingByDirection((Direction)next.right())));
            context.m_43725_().m_7731_(context.m_8083_(), state, 3);
            gate.getMergeHelper().updateMemberStateAndCheck(null);
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return (BlockState)blockState.m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)BlockPosHelper.flipDir((Direction)blockState.m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY), mirror));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean shift = player.m_6144_();
        boolean guiDisplayed = false;
        boolean camoChanged = false;
        if (!level.f_46443_) {
            BlockEntity blockEntity;
            if (!shift && (blockEntity = level.m_7702_(pos)) instanceof StargateAbstractMemberBE) {
                Block block;
                StargateAbstractMemberBE tile = (StargateAbstractMemberBE)blockEntity;
                if (tile.basePos != null && hand == InteractionHand.MAIN_HAND && (block = level.m_8055_(tile.basePos).m_60734_()) instanceof StargateAbstractBaseBlock) {
                    StargateAbstractBaseBlock block2 = (StargateAbstractBaseBlock)block;
                    camoChanged = tile.setCamoBlockByHeldItem(player.m_21120_(hand), player, new BlockPlaceContext(level, player, hand, player.m_21120_(hand), hitResult));
                    if (!camoChanged) {
                        guiDisplayed = block2.showGateInfo(player, hand, level, tile.basePos);
                    }
                }
            }
        } else {
            return InteractionResult.m_19078_((boolean)true);
        }
        return !shift && (guiDisplayed || camoChanged) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    @ParametersAreNonnullByDefault
    public void m_7592_(Level level, BlockPos pos, Explosion explosion) {
        BlockEntity blockEntity;
        super.m_7592_(level, pos, explosion);
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof StargateAbstractMemberBE) {
            StargateAbstractMemberBE member = (StargateAbstractMemberBE)blockEntity;
            member.dropCamo();
        }
    }

    @Override
    public boolean renderHighlight(BlockState blockState, BlockGetter level, BlockPos pos) {
        CamouflageBE camoBE;
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof CamouflageBE && !(camoBE = (CamouflageBE)tile).getCamoBlock().m_60795_()) {
            return true;
        }
        return blockState.m_61138_((Property)JSGProperties.RENDER_BLOCK_PROPERTY) && (Boolean)blockState.m_61143_((Property)JSGProperties.RENDER_BLOCK_PROPERTY) != false;
    }

    public void m_5871_(@NotNull ItemStack itemStack, @Nullable BlockGetter blockGetter, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        ItemHelper.applyGenericToolTip(this.m_7705_(), components, tooltipFlag);
    }

    @ParametersAreNonnullByDefault
    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        super.m_6402_(level, blockPos, blockState, livingEntity, itemStack);
        if (level.f_46443_) {
            return;
        }
        BlockEntity e = level.m_7702_(blockPos);
        if (e instanceof StargateAbstractMemberBE) {
            ((StargateAbstractMemberBE)e).findBaseAndUpdateMergeState(null);
        }
    }

    @ParametersAreNonnullByDefault
    public void m_5707_(Level level, BlockPos pos, BlockState blockState, Player player) {
        BlockEntity blockEntity;
        super.m_5707_(level, pos, blockState, player);
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof StargateAbstractMemberBE) {
            StargateAbstractMemberBE e = (StargateAbstractMemberBE)blockEntity;
            e.findBaseAndUpdateMergeState(false);
            e.dropCamo();
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        StargateAbstractMemberBE e;
        boolean camoChanged;
        BlockEntity blockEntity;
        if (player.m_7500_() && !level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof StargateAbstractMemberBE && (camoChanged = (e = (StargateAbstractMemberBE)blockEntity).setCamoBlockByHeldItem(ItemStack.f_41583_, player, null))) {
            return false;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @ParametersAreNonnullByDefault
    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity;
        if (!player.m_7500_() && !level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof StargateAbstractMemberBE) {
            StargateAbstractMemberBE e = (StargateAbstractMemberBE)blockEntity;
            e.setCamoBlockByHeldItem(ItemStack.f_41583_, player, null);
        }
        super.m_6256_(state, level, pos, player);
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{JSGProperties.RENDER_BLOCK_PROPERTY});
        builder.m_61104_(new Property[]{JSGProperties.FACING_HORIZONTAL_PROPERTY});
        builder.m_61104_(new Property[]{JSGProperties.FACING_VERTICAL_PROPERTY});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    @NotNull
    public FluidState m_5888_(BlockState p_152045_) {
        return (Boolean)p_152045_.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_152045_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        float pitch = 0.0f;
        if (ctx.m_43723_() != null) {
            pitch = ctx.m_43723_().m_146909_();
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)JSGProperties.FACING_VERTICAL_PROPERTY, (Comparable)Integer.valueOf(JSGProperties.getVerticalFacingByDirection(JSGProperties.getVerticalDirectionByPitch(pitch).m_122424_())))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public RenderShape m_7514_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)JSGProperties.RENDER_BLOCK_PROPERTY) != false ? RenderShape.MODEL : RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return (Boolean)blockState.m_61143_((Property)JSGProperties.RENDER_BLOCK_PROPERTY) != false ? Shapes.m_83144_() : StargateAbstractBaseBlock.getGateBlockShape(blockState, blockGetter, blockPos);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape m_5909_(BlockState blockState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return (Boolean)blockState.m_61143_((Property)JSGProperties.RENDER_BLOCK_PROPERTY) != false ? Shapes.m_83144_() : Shapes.m_83040_();
    }

    @ParametersAreNonnullByDefault
    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }
}

