/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity.cartouche;

import dev.tauri.jsg.api.helper.DimensionsHelper;
import dev.tauri.jsg.api.pointoforigins.PointOfOrigin;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.stargate.network.StargatePos;
import dev.tauri.jsg.api.stargate.network.address.IAddress;
import dev.tauri.jsg.api.stargate.network.address.StargateAddress;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.SymbolMilkyWayEnum;
import dev.tauri.jsg.api.state.State;
import dev.tauri.jsg.api.state.StateType;
import dev.tauri.jsg.api.util.JSGAxisAlignedBB;
import dev.tauri.jsg.api.util.RotationUtil;
import dev.tauri.jsg.api.util.blockentity.IPreparable;
import dev.tauri.jsg.api.util.blockentity.ITickable;
import dev.tauri.jsg.block.cartouche.CartoucheBlock;
import dev.tauri.jsg.block.cartouche.CartoucheType;
import dev.tauri.jsg.blockentity.CamouflageBE;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.StateUpdatePacketToClient;
import dev.tauri.jsg.registry.BlockEntityRegistry;
import dev.tauri.jsg.renderer.cartouche.CartoucheRendererState;
import dev.tauri.jsg.stargate.network.StargateNetwork;
import dev.tauri.jsg.state.StateProviderInterface;
import it.unimi.dsi.fastutil.Pair;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CartoucheBE
extends CamouflageBE
implements ITickable,
StateProviderInterface,
IPreparable {
    public StargateAddressDynamic savedAddress;
    public int[] symbolsToDisplay;
    protected PointOfOrigin origin;
    public DyeColor color = DyeColor.BLACK;
    public boolean shiny;
    public CartoucheRendererState renderStateClient;
    protected boolean needRegeneration;
    protected ResourceLocation regenerationForDim;
    protected String regenerationForSymbolType;
    private PacketDistributor.TargetPoint targetPoint;

    public CartoucheBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegistry.CARTOUCHE.get(), pPos, pBlockState);
    }

    public void setAddress(StargateAddressDynamic address, @Nullable PointOfOrigin origin, int[] symbolsToDisplay) {
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        this.savedAddress = address;
        this.origin = origin;
        this.symbolsToDisplay = this.processSymbolsToDisplay(symbolsToDisplay);
        this.m_6596_();
        this.getAndSendState(StateType.RENDERER_STATE);
    }

    protected int[] processSymbolsToDisplay(@Nullable int[] symbolsToDisplay) {
        if (symbolsToDisplay == null) {
            return new int[0];
        }
        Block block = this.m_58900_().m_60734_();
        if (!(block instanceof CartoucheBlock)) {
            return new int[0];
        }
        CartoucheBlock cartoucheBlock = (CartoucheBlock)block;
        CartoucheType type = cartoucheBlock.type;
        return Arrays.stream(symbolsToDisplay).filter(symbolPos -> {
            if (symbolPos > type.symbolsCount && symbolPos != 9) {
                return false;
            }
            return symbolPos != 9 || type.hasPoo;
        }).toArray();
    }

    public void setColor(DyeColor color) {
        this.color = color;
        this.m_6596_();
        this.getAndSendState(StateType.RENDERER_STATE);
    }

    public void setShiny(boolean shiny) {
        this.shiny = shiny;
        this.m_6596_();
        this.getAndSendState(StateType.RENDERER_STATE);
    }

    public int[] getSymbolsToDisplay() {
        return this.processSymbolsToDisplay(this.symbolsToDisplay);
    }

    @Nullable
    public IAddress getAddress() {
        if (this.savedAddress == null) {
            return null;
        }
        return new StargateAddressDynamic(this.savedAddress);
    }

    @Nullable
    public PointOfOrigin getPointOfOrigin() {
        return this.origin;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.m_58904_() == null) {
            return;
        }
        if (this.m_58904_().m_5776_()) {
            this.requestState(StateType.RENDERER_STATE);
        } else {
            this.getAndSendState(StateType.RENDERER_STATE);
            this.tryRegenerate(this.m_58904_());
        }
    }

    protected void tryRegenerate(Level level) {
        Pair<StargatePos, StargateAddress> gate;
        AbstractSymbolType<Object> symbolType;
        if (!this.needRegeneration) {
            return;
        }
        this.needRegeneration = false;
        this.color = DyeColor.BLACK;
        RandomSource random = level.f_46441_;
        this.symbolsToDisplay = Stargate.getRandomSymbolsToDisplay(8, symbolIndex -> {
            if (symbolIndex == 9) {
                return !(random.m_188501_() < 0.1f);
            }
            return !(random.m_188501_() < 0.05f);
        });
        this.symbolsToDisplay = this.processSymbolsToDisplay(this.symbolsToDisplay);
        this.m_6596_();
        StargateNetwork sgn = StargateNetwork.INSTANCE;
        ResourceKey<Level> dim = this.regenerationForDim == null ? null : DimensionsHelper.getDimension(this.regenerationForDim);
        AbstractSymbolType<Object> abstractSymbolType = symbolType = this.regenerationForSymbolType == null ? null : AbstractSymbolType.byId(this.regenerationForSymbolType);
        if (symbolType == null) {
            symbolType = SymbolTypeRegistry.MILKYWAY;
        }
        if ((gate = sgn.getRandomAddress(random, symbolType, null, sgPos -> {
            if (dim == null) {
                return true;
            }
            return dim == sgPos.dimension;
        })) == null) {
            return;
        }
        this.savedAddress = new StargateAddressDynamic((StargateAddress)gate.second()).addOriginIfMissingAndImmutable();
        this.origin = Stargate.getOriginFor(symbolType.getPointOfOriginType(), (ResourceKey<Level>)level.m_46472_(), BiomeOverlayRegistry.getBiomeOverlayByBlockPos(level, this.m_58899_(), false));
        this.m_6596_();
    }

    public JSGAxisAlignedBB getRenderBoundingBox() {
        return RotationUtil.rotate(new JSGAxisAlignedBB(0.0, 0.0, 0.0, 1.0, 3.0, 0.3), RotationUtil.getRotation(this.m_58900_()), new Vec3(0.5, 0.5, 0.5)).offset(this.m_58899_());
    }

    @Override
    public void tick(Level level) {
    }

    @Override
    public State getState(StateType stateType) {
        if (stateType == StateType.RENDERER_STATE) {
            return new CartoucheRendererState(this.savedAddress, this.origin, this.symbolsToDisplay, this.color, this.shiny);
        }
        return super.getState(stateType);
    }

    @Override
    public State createState(StateType stateType) {
        if (stateType == StateType.RENDERER_STATE) {
            return new CartoucheRendererState();
        }
        return super.createState(stateType);
    }

    @Override
    public void setState(StateType stateType, State state) {
        if (stateType == StateType.RENDERER_STATE) {
            this.renderStateClient = (CartoucheRendererState)state;
            this.savedAddress = this.renderStateClient.address;
            this.origin = this.renderStateClient.origin;
            this.color = this.renderStateClient.color;
            this.shiny = this.renderStateClient.shiny;
            this.symbolsToDisplay = this.renderStateClient.symbolsToDisplay;
            this.m_6596_();
        }
        super.setState(stateType, state);
    }

    public PacketDistributor.TargetPoint getTargetPoint() {
        if (this.m_58904_() == null) {
            return this.targetPoint;
        }
        if (this.targetPoint == null) {
            BlockPos pos = this.m_58899_();
            this.targetPoint = new PacketDistributor.TargetPoint((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 512.0, this.m_58904_().m_46472_());
        }
        return this.targetPoint;
    }

    @Override
    public void sendState(StateType type, State state) {
        JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(this.m_58899_(), type, state), this.getTargetPoint());
    }

    @Override
    @ParametersAreNonnullByDefault
    public void m_183515_(CompoundTag compound) {
        if (this.savedAddress != null) {
            compound.m_128365_("savedAddress", (Tag)this.savedAddress.serializeNBT());
        }
        if (this.origin != null) {
            compound.m_128365_("origin", (Tag)this.origin.serializeNBT());
        }
        compound.m_128379_("needRegeneration", this.needRegeneration);
        if (this.regenerationForDim != null) {
            compound.m_128359_("regenerationForDim", this.regenerationForDim.toString());
        }
        if (this.regenerationForSymbolType != null) {
            compound.m_128359_("regenerationForSymbolType", this.regenerationForSymbolType);
        }
        if (this.symbolsToDisplay != null) {
            compound.m_128385_("symbolsToDisplay", this.symbolsToDisplay);
        }
        compound.m_128405_("color", this.color.m_41060_());
        compound.m_128379_("shiny", this.shiny);
        super.m_183515_(compound);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("savedAddress")) {
            this.savedAddress = new StargateAddressDynamic(compound.m_128469_("savedAddress"));
        }
        if (compound.m_128441_("origin")) {
            this.origin = PointOfOrigin.fromNBT(compound.m_128469_("origin"), null);
        }
        this.needRegeneration = compound.m_128471_("needRegeneration");
        if (compound.m_128441_("regenerationForDim")) {
            this.regenerationForDim = new ResourceLocation(compound.m_128461_("regenerationForDim"));
        }
        if (compound.m_128441_("regenerationForSymbolType")) {
            this.regenerationForSymbolType = compound.m_128461_("regenerationForSymbolType");
        }
        if (compound.m_128441_("symbolsToDisplay")) {
            this.symbolsToDisplay = compound.m_128465_("symbolsToDisplay");
        }
        if (compound.m_128441_("color")) {
            this.color = DyeColor.m_41053_((int)compound.m_128451_("color"));
        }
        this.shiny = compound.m_128471_("shiny");
        super.m_142466_(compound);
    }

    @Override
    public boolean prepareBE() {
        return this.prepareBE(null);
    }

    @Override
    public boolean prepareBE(@Nullable String arg) {
        this.needRegeneration = true;
        this.savedAddress = new StargateAddressDynamic(SymbolTypeRegistry.MILKYWAY);
        for (int i = 0; i < 8; ++i) {
            this.savedAddress.addSymbol(SymbolMilkyWayEnum.SCULPTOR);
        }
        this.savedAddress = this.savedAddress.addOriginIfMissingAndImmutable();
        this.origin = null;
        this.symbolsToDisplay = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        if (arg == null) {
            this.regenerationForDim = null;
        } else {
            String[] splitArgs = arg.split(",");
            this.regenerationForDim = new ResourceLocation(splitArgs[0]);
            this.regenerationForSymbolType = splitArgs.length > 1 ? splitArgs[1] : null;
        }
        this.m_6596_();
        this.getAndSendState(StateType.RENDERER_STATE);
        return true;
    }
}

