/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity.dialhomedevice;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.advancements.JSGAdvancements;
import dev.tauri.jsg.api.client.screen.util.DHDScreenHelper;
import dev.tauri.jsg.api.config.ingame.BEConfig;
import dev.tauri.jsg.api.config.ingame.option.StargateConfigOptions;
import dev.tauri.jsg.api.integration.SignalHolder;
import dev.tauri.jsg.api.integration.StargateComputerEvents;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import dev.tauri.jsg.api.stargate.EnumStargateState;
import dev.tauri.jsg.api.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.SymbolMilkyWayEnum;
import dev.tauri.jsg.api.stargate.result.StargateChevronEngageResult;
import dev.tauri.jsg.api.stargate.result.StargateCloseResult;
import dev.tauri.jsg.api.stargate.result.StargateOpenResult;
import dev.tauri.jsg.api.state.State;
import dev.tauri.jsg.api.state.StateType;
import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.blockentity.util.ILinkable;
import dev.tauri.jsg.helpers.LinkingHelper;
import dev.tauri.jsg.registry.BlockEntityRegistry;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.registry.tags.JSGBlockTags;
import dev.tauri.jsg.renderer.dialhomedevice.DHDMilkyWayRendererState;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.sound.SoundEvent;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.state.dialhomedevice.DHDActivateButtonState;
import dev.tauri.jsg.state.stargate.StargateBiomeOverrideState;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class DHDMilkyWayBE
extends DHDAbstractBE {
    public static final List<BiomeOverlayRegistry.BiomeOverlayInstance> SUPPORTED_OVERLAYS = List.of(BiomeOverlayRegistry.NORMAL, BiomeOverlayRegistry.FROST, BiomeOverlayRegistry.MOSSY, BiomeOverlayRegistry.SOOTY, BiomeOverlayRegistry.AGED);

    public DHDMilkyWayBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.DHD_MILKYWAY.get(), pos, state);
    }

    @Override
    public List<BiomeOverlayRegistry.BiomeOverlayInstance> getSupportedOverlays() {
        return SUPPORTED_OVERLAYS;
    }

    @Override
    public void tick(@NotNull Level level) {
        if (level.f_46443_ && level.m_46467_() % 40L == 0L && this.rendererStateClient != null && this.getRendererStateClient().biomeOverride == null) {
            this.rendererStateClient.setBiomeOverlay(BiomeOverlayRegistry.getUpdatedBiomeOverlay(level, this.m_58899_(), SUPPORTED_OVERLAYS));
        }
        super.tick(level);
    }

    @Override
    public DHDScreenHelper getScreenHelper() {
        return DHDScreenHelper.getMilkyWay();
    }

    @Override
    public AbstractSymbolType<?> getSymbolType() {
        return SymbolTypeRegistry.MILKYWAY;
    }

    @Override
    public Item getControlCrystal() {
        return (Item)ItemRegistry.CRYSTAL_CONTROL_MILKYWAY_DHD.get();
    }

    @Override
    public void activateSymbol(SymbolInterface symbolInt) {
        if (this.f_58857_ == null) {
            return;
        }
        Object gateTile = this.getLinkedDevice();
        if (gateTile == null) {
            return;
        }
        SymbolMilkyWayEnum symbol = SymbolTypeRegistry.MILKYWAY.valueOf(symbolInt.getId());
        if (!((StargateAbstractDialingManager)((StargateAbstractBaseBE)gateTile).getDialingManager()).getStargateState().dialingComputer() || ((StargateClassicBaseBE)gateTile).getConfig().getValueOrDefault(StargateConfigOptions.Classic.DHD_OC_PRESS_SOUND).booleanValue()) {
            if (symbol.brb()) {
                JSGSoundHelper.playSoundEvent(this.f_58857_, this.m_58899_(), SoundEvent.DHD_MILKYWAY_PRESS_BRB);
            } else {
                JSGSoundHelper.playSoundEvent(this.f_58857_, this.m_58899_(), SoundEvent.DHD_MILKYWAY_PRESS);
            }
        }
        this.f_58857_.m_151543_(this.m_58899_());
        this.sendState(StateType.DHD_ACTIVATE_BUTTON, new DHDActivateButtonState(symbol));
    }

    @Override
    public void pushSymbolButton(SymbolInterface symbol, @Nullable ServerPlayer player, boolean force) {
        if (((IItemHandler)this.getCapability(ForgeCapabilities.ITEM_HANDLER, null).resolve().orElseThrow()).getStackInSlot(0).m_41619_()) {
            if (player != null) {
                player.m_240418_((Component)Component.m_237115_((String)"block.jsg.dhd_milkyway.no_crystal_warn"), true);
            }
            return;
        }
        if (!this.isLinked()) {
            if (player != null) {
                player.m_240418_((Component)Component.m_237115_((String)"block.jsg.dhd_milkyway.not_linked_warn"), true);
            }
            return;
        }
        StargateClassicBaseBE gateTile = (StargateClassicBaseBE)this.getLinkedDevice();
        EnumStargateState gateState = ((StargateAbstractDialingManager)Objects.requireNonNull(gateTile).getDialingManager()).getStargateState();
        if (gateState.engaged() && symbol.brb()) {
            if (gateState.initiating()) {
                ((StargateAbstractDialingManager)gateTile.getDialingManager()).attemptClose(StargateClosedReasonEnum.REQUESTED);
            } else if (player != null) {
                ((SignalHolder)StargateComputerEvents.ATTEMPT_CLOSE_FAILED.apply((Object)StargateCloseResult.NOT_INITIATING, (Object)((StargateAbstractDialingManager)gateTile.getDialingManager()).getDialedAddress(), (Object)false)).sendVia(gateTile);
                player.m_240418_((Component)Component.m_237115_((String)"block.jsg.dhd_milkyway.incoming_wormhole_warn"), true);
            }
        } else if (gateState.idle()) {
            if (symbol.brb()) {
                StargateOpenResult openResult = ((StargateAbstractDialingManager)gateTile.getDialingManager()).attemptOpenDialed();
                if (openResult.ok()) {
                    JSGAdvancements.CHEVRON_SEVEN_LOCKED.trigger(player);
                }
                if (openResult == StargateOpenResult.NOT_ENOUGH_POWER && player != null) {
                    player.m_240418_((Component)Component.m_237115_((String)"block.jsg.dhd_milkyway.not_enough_power"), true);
                }
            } else {
                StargateChevronEngageResult r = ((StargateAbstractDialingManager)gateTile.getDialingManager()).engageSymbolDHD(symbol, false, false);
                JSG.logger.debug(r.name());
            }
        }
    }

    @Override
    public void updateLinkStatus(Level world, BlockPos pos) {
        ILinkable gateTile;
        BlockPos closestGate;
        Object object;
        if (this.isLinked() && (object = this.getLinkedDevice()) instanceof ILinkable) {
            ILinkable linkable = (ILinkable)object;
            linkable.setLinkedDevice(null);
            this.setLinkedDevice(null);
        }
        if ((closestGate = LinkingHelper.findClosestUnlinked(world, pos, LinkingHelper.getDhdRange(), JSGBlockTags.DHD_MILKYWAY_LINKABLE_BLOCKS)) != null && (gateTile = (ILinkable)world.m_7702_(closestGate)) != null) {
            gateTile.setLinkedDevice(pos);
            this.setLinkedDevice(closestGate);
        }
    }

    @Override
    public State getState(StateType stateType) {
        if (stateType == StateType.RENDERER_STATE) {
            Object gateTile;
            StargateAddressDynamic address = new StargateAddressDynamic(SymbolTypeRegistry.MILKYWAY);
            BEConfig config = new BEConfig();
            if (this.isLinked() && (gateTile = this.getLinkedDevice()) != null) {
                address.addAll(((StargateAbstractDialingManager)((StargateAbstractBaseBE)gateTile).getDialingManager()).getDialedAddress());
                boolean brbActive = false;
                switch (((StargateAbstractDialingManager)((StargateAbstractBaseBE)gateTile).getDialingManager()).getStargateState()) {
                    case ENGAGED_INITIATING: {
                        brbActive = true;
                        break;
                    }
                    case ENGAGED: {
                        address.clear();
                        brbActive = true;
                        break;
                    }
                }
                if (gateTile instanceof StargateClassicBaseBE) {
                    config = ((StargateClassicBaseBE)gateTile).getConfig();
                }
                return new DHDMilkyWayRendererState(address, brbActive, this.determineBiomeOverride(), !((StargateAbstractDialingManager)((StargateAbstractBaseBE)gateTile).getDialingManager()).getConnection().getStatus().none(), config);
            }
            return new DHDMilkyWayRendererState(address, false, this.determineBiomeOverride(), false, config);
        }
        throw new UnsupportedOperationException("EnumStateType." + stateType.name() + " not implemented on " + this.getClass().getName());
    }

    @Override
    public State createState(StateType stateType) {
        if (stateType == StateType.RENDERER_STATE) {
            return new DHDMilkyWayRendererState();
        }
        return super.createState(stateType);
    }

    @Override
    public void setState(StateType stateType, State state) {
        Object gateTile;
        if (this.f_58857_ == null) {
            return;
        }
        boolean connected = this.isLinked() ? ((gateTile = this.getLinkedDevice()) != null ? !((StargateAbstractDialingManager)((StargateAbstractBaseBE)gateTile).getDialingManager()).getConnection().getStatus().none() : false) : false;
        stateType.stateExecutor().tryType(StateType.RENDERER_STATE, () -> {
            this.rendererStateClient = ((DHDMilkyWayRendererState)state).initClient(this.m_58899_(), BiomeOverlayRegistry.getUpdatedBiomeOverlay(this.f_58857_, this.m_58899_(), SUPPORTED_OVERLAYS), connected);
        }).tryType(StateType.DHD_ACTIVATE_BUTTON, () -> {
            if (state != null) {
                DHDActivateButtonState activateState = (DHDActivateButtonState)state;
                this.getRendererStateClient().setIsConnected(connected);
                if (activateState.clearAll) {
                    ((DHDMilkyWayRendererState)this.getRendererStateClient()).clearSymbols(this.f_58857_.m_46467_());
                } else {
                    ((DHDMilkyWayRendererState)this.getRendererStateClient()).activateSymbol(this.f_58857_.m_46467_(), SymbolTypeRegistry.MILKYWAY.valueOf(activateState.symbol));
                }
            }
        }).tryType(StateType.BIOME_OVERRIDE_STATE, () -> {
            StargateBiomeOverrideState overrideState = (StargateBiomeOverrideState)state;
            if (this.rendererStateClient != null) {
                this.getRendererStateClient().biomeOverride = overrideState.biomeOverride;
            }
        }).run();
        super.setState(stateType, state);
    }
}

