/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity.stargate;

import dev.tauri.jsg.api.blockstates.JSGProperties;
import dev.tauri.jsg.api.sound.StargateSoundEventEnum;
import dev.tauri.jsg.api.sound.StargateSoundPositionedEnum;
import dev.tauri.jsg.api.stargate.type.StargateType;
import dev.tauri.jsg.api.stargate.type.StargateTypes;
import dev.tauri.jsg.blockentity.stargate.StargateMilkyWayBaseBE;
import dev.tauri.jsg.multistructure.mergehelper.StargateMovieMergeHelper;
import dev.tauri.jsg.registry.BlockEntityRegistry;
import dev.tauri.jsg.renderer.stargate.StargateMilkyWayRendererState;
import dev.tauri.jsg.sound.PositionedSound;
import dev.tauri.jsg.sound.SoundEvent;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.dialing.StargateMovieDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import dev.tauri.jsg.stargate.manager.state.StargateMovieStateManager;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StargateMovieBaseBE
extends StargateMilkyWayBaseBE {
    public StargateMovieBaseBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.STARGATE_MOVIE_BASE_BE.get(), pos, state);
    }

    @Override
    public StargateAbstractStateManager<StargateMilkyWayBaseBE, StargateMilkyWayRendererState> createStateManager() {
        return new StargateMovieStateManager(this);
    }

    @Override
    public StargateAbstractDialingManager<?> createDialingManager() {
        return new StargateMovieDialingManager(this);
    }

    @Override
    public StargateType getStargateType() {
        return StargateTypes.MOVIE;
    }

    @Override
    public void generateMergeHelper() {
        this.mergeHelper = new StargateMovieMergeHelper(this);
        this.mergeHelper.horizontalFacing = (Direction)this.m_58900_().m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY);
        this.mergeHelper.verticalFacing = JSGProperties.getDirectionByVerticalFacing((Integer)this.m_58900_().m_61143_((Property)JSGProperties.FACING_VERTICAL_PROPERTY));
        this.mergeHelper.stargateSize = this.getStargateSize();
        this.mergeHelper.basePos = this.m_58899_();
    }

    @Override
    public PositionedSound getPositionedSound(StargateSoundPositionedEnum soundEnum) {
        return switch (soundEnum) {
            default -> throw new IncompatibleClassChangeError();
            case StargateSoundPositionedEnum.GATE_RING_ROLL -> PositionedSound.MOVIE_RING_ROLL;
            case StargateSoundPositionedEnum.GATE_RING_ROLL_START -> PositionedSound.MOVIE_RING_ROLL_START;
        };
    }

    @Override
    @Nullable
    public SoundEvent getSoundEvent(StargateSoundEventEnum soundEnum) {
        return switch (soundEnum) {
            case StargateSoundEventEnum.OPEN -> SoundEvent.GATE_MOVIE_OPEN;
            case StargateSoundEventEnum.OPEN_NOX -> SoundEvent.GATE_NOX_OPEN;
            case StargateSoundEventEnum.CLOSE -> SoundEvent.GATE_MOVIE_CLOSE;
            case StargateSoundEventEnum.DIAL_FAILED -> {
                if (((StargateAbstractDialingManager)this.getDialingManager()).getStargateState().dialingComputer()) {
                    yield SoundEvent.GATE_MILKYWAY_DIAL_FAILED_COMPUTER;
                }
                yield SoundEvent.GATE_MILKYWAY_DIAL_FAILED;
            }
            case StargateSoundEventEnum.INCOMING, StargateSoundEventEnum.CHEVRON_OPEN -> SoundEvent.GATE_MOVIE_CHEVRON_OPEN;
            case StargateSoundEventEnum.RING_STOP -> SoundEvent.GATE_MOVIE_RING_ROLL_STOP;
            case StargateSoundEventEnum.CHEVRON_SHUT -> SoundEvent.GATE_MOVIE_CHEVRON_CLOSE;
            default -> null;
        };
    }

    @Override
    public int getCloseSoundDelay() {
        return 30;
    }
}

