/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity.stargate;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.blockstates.JSGProperties;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.power.general.EnergyRequiredToOperate;
import dev.tauri.jsg.api.power.general.SmallEnergyStorage;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import dev.tauri.jsg.api.sound.StargateSoundEventEnum;
import dev.tauri.jsg.api.sound.StargateSoundPositionedEnum;
import dev.tauri.jsg.api.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.api.stargate.network.StargatePos;
import dev.tauri.jsg.api.stargate.network.address.StargateAddress;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.stargate.type.StargateType;
import dev.tauri.jsg.api.stargate.type.StargateTypes;
import dev.tauri.jsg.api.util.IStargateGenerator;
import dev.tauri.jsg.api.util.JSGAxisAlignedBB;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.util.ILinkable;
import dev.tauri.jsg.multistructure.mergehelper.StargateOrlinMergeHelper;
import dev.tauri.jsg.registry.BlockEntityRegistry;
import dev.tauri.jsg.renderer.stargate.StargateOrlinRendererState;
import dev.tauri.jsg.sound.PositionedSound;
import dev.tauri.jsg.sound.SoundEvent;
import dev.tauri.jsg.stargate.manager.StargateEnergyManager;
import dev.tauri.jsg.stargate.manager.StargateEventHorizonManager;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.dialing.StargateOrlinDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import dev.tauri.jsg.stargate.manager.state.StargateOrlinStateManager;
import dev.tauri.jsg.stargate.network.StargateNetwork;
import dev.tauri.jsg.worldgen.generator.StargateGenerator;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StargateOrlinBaseBE
extends StargateAbstractBaseBE<StargateOrlinRendererState, SmallEnergyStorage> {
    public boolean canNotGenerate = false;
    private int openCount = 0;
    private boolean isPowered;
    private final SmallEnergyStorage energyStorage = new SmallEnergyStorage(){

        @Override
        protected void onEnergyChanged() {
            StargateOrlinBaseBE.this.m_6596_();
        }
    };
    public CompoundTag notebookPageTag = null;

    public StargateOrlinBaseBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.STARGATE_ORLIN_BASE_BE.get(), pos, state);
    }

    @Override
    public StargateAbstractStateManager<StargateOrlinBaseBE, StargateOrlinRendererState> createStateManager() {
        return new StargateOrlinStateManager(this);
    }

    @Override
    public StargateAbstractDialingManager<StargateOrlinBaseBE> createDialingManager() {
        return new StargateOrlinDialingManager(this);
    }

    @Override
    public StargateOrlinDialingManager getDialingManager() {
        return (StargateOrlinDialingManager)super.getDialingManager();
    }

    @Override
    public StargateEnergyManager<StargateOrlinBaseBE, SmallEnergyStorage> createEnergyManager() {
        return new StargateEnergyManager<StargateOrlinBaseBE, SmallEnergyStorage>(this){

            @Override
            public SmallEnergyStorage getStorage() {
                return StargateOrlinBaseBE.this.energyStorage;
            }

            @Override
            public EnergyRequiredToOperate getEnergyRequiredToDial(@Nullable StargatePos targetGatePos, StargateAddressDynamic address) {
                return super.getEnergyRequiredToDial(targetGatePos, address).mul(JSGConfig.Stargate.stargateOrlinEnergyMul.get()).cap(JSGConfig.Stargate.stargateEnergyStorage.get() / 4 - 1000000);
            }
        };
    }

    @Override
    public StargateEventHorizonManager createEventHorizonManager() {
        return new StargateEventHorizonManager(this){

            @Override
            public JSGAxisAlignedBB getTeleportBox() {
                return new JSGAxisAlignedBB(-1.0, 0.6, -0.15, 1.0, 2.7, -0.05);
            }

            @Override
            public boolean getForceUnstable() {
                return false;
            }

            @Override
            public int getKawooshSegmentsCount() {
                return 2;
            }

            @Override
            public List<JSGAxisAlignedBB> getGateVaporizingBoxes() {
                return Collections.singletonList(new JSGAxisAlignedBB(-0.5, 1.0, -0.5, 0.5, 2.0, 0.5));
            }

            @Override
            public JSGAxisAlignedBB getHorizonKillingBox() {
                return new JSGAxisAlignedBB(-0.5, 1.0, -0.5, 0.5, 2.0, 1.5);
            }
        };
    }

    @Nullable
    public StargateAddress getAddressFromPageNBT() {
        if (this.notebookPageTag == null) {
            return this.setUpRandomGate();
        }
        if (!this.notebookPageTag.m_128441_("address")) {
            return this.setUpRandomGate();
        }
        CompoundTag address = this.notebookPageTag.m_128469_("address");
        return new StargateAddress(address);
    }

    @Nullable
    private StargateAddress setUpRandomGate() {
        if (this.f_58857_ == null) {
            return null;
        }
        Pair<StargatePos, StargateAddress> gate = StargateNetwork.INSTANCE.getRandomAddress(this.f_58857_.m_213780_(), SymbolTypeRegistry.MILKYWAY, StargateTypes.MILKYWAY, null);
        if (gate == null) {
            return null;
        }
        CompoundTag tag = ((StargateAddress)gate.second()).serializeNBT();
        if (this.notebookPageTag == null) {
            this.notebookPageTag = new CompoundTag();
        }
        this.notebookPageTag.m_128365_("address", (Tag)tag);
        return (StargateAddress)gate.second();
    }

    @Nullable
    public EnergyRequiredToOperate getEnergyRequiredToDial() {
        StargateAddress addressToDial = this.getAddressFromPageNBT();
        if (addressToDial == null) {
            return new EnergyRequiredToOperate(0, 0);
        }
        StargatePos sgPos = StargateNetwork.INSTANCE.getStargate(addressToDial);
        if (sgPos == null) {
            return null;
        }
        return ((StargateEnergyManager)this.getEnergyManager()).getEnergyRequiredToDial(sgPos, new StargateAddressDynamic(addressToDial));
    }

    @Override
    public void generateMergeHelper() {
        this.mergeHelper = new StargateOrlinMergeHelper(this);
        this.mergeHelper.horizontalFacing = (Direction)this.m_58900_().m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY);
        this.mergeHelper.verticalFacing = JSGProperties.getDirectionByVerticalFacing((Integer)this.m_58900_().m_61143_((Property)JSGProperties.FACING_VERTICAL_PROPERTY));
        this.mergeHelper.basePos = this.m_58899_();
    }

    @Override
    public AbstractSymbolType<?> getSymbolType() {
        return SymbolTypeRegistry.MILKYWAY;
    }

    @Override
    public StargateType getStargateType() {
        return StargateTypes.ORLIN;
    }

    @Override
    @Nullable
    public PositionedSound getPositionedSound(StargateSoundPositionedEnum soundEnum) {
        return null;
    }

    @Override
    @Nullable
    public SoundEvent getSoundEvent(StargateSoundEventEnum soundEnum) {
        return switch (soundEnum) {
            case StargateSoundEventEnum.OPEN -> SoundEvent.GATE_MILKYWAY_OPEN;
            case StargateSoundEventEnum.OPEN_NOX -> SoundEvent.GATE_NOX_OPEN;
            case StargateSoundEventEnum.CLOSE -> SoundEvent.GATE_MILKYWAY_CLOSE;
            case StargateSoundEventEnum.DIAL_FAILED -> SoundEvent.GATE_ORLIN_FAIL;
            case StargateSoundEventEnum.GATE_BROKE -> SoundEvent.GATE_ORLIN_BROKE;
            default -> null;
        };
    }

    @Override
    public BlockPos getGateCenterPos() {
        return this.m_58899_().m_7494_();
    }

    @Override
    public List<BiomeOverlayRegistry.BiomeOverlayInstance> getSupportedOverlays() {
        return List.of(BiomeOverlayRegistry.NORMAL);
    }

    public void initializeFromItemStack(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag compound = stack.m_41784_();
            if (compound.m_128441_("openCount")) {
                this.openCount = compound.m_128451_("openCount");
            }
            if (compound.m_128441_("notebook_page")) {
                this.notebookPageTag = compound.m_128469_("notebook_page");
            }
        }
    }

    public void incrementOpenCount() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        ++this.openCount;
        this.getMergeHelper().incrementMembersOpenCount();
        if (this.isBroken(true)) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_((Property)JSGProperties.ORLIN_BROKEN, (Comparable)Boolean.valueOf(true)), 3);
        }
        this.m_6596_();
    }

    @Override
    public StargateOrlinMergeHelper getMergeHelper() {
        return (StargateOrlinMergeHelper)super.getMergeHelper();
    }

    public boolean isBroken(boolean onlyBase) {
        int max = JSGConfig.Stargate.stargateOrlinMaxOpenCount.get();
        if (max <= 0) {
            return false;
        }
        if (this.openCount >= max) {
            return true;
        }
        if (onlyBase) {
            return false;
        }
        return this.getMergeHelper().getMaxOpenCount() >= max;
    }

    public void redstonePowerUpdate(boolean power) {
        if (!this.isMerged()) {
            return;
        }
        if (this.isPowered && !power || !this.isPowered && power) {
            this.isPowered = power;
            if (this.isPowered && this.getDialingManager().getStargateState().idle() && !this.isBroken(false)) {
                this.getDialingManager().beginOpening();
            } else if (!this.isPowered && this.getDialingManager().getStargateState().initiating()) {
                this.getDialingManager().attemptClose(StargateClosedReasonEnum.REQUESTED);
            }
            this.m_6596_();
        }
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        compound.m_128379_("isPowered", this.isPowered);
        compound.m_128405_("openCount", this.openCount);
        compound.m_128379_("canNotGenerate", this.canNotGenerate);
        if (this.notebookPageTag != null) {
            compound.m_128365_("notebook_page", (Tag)this.notebookPageTag);
        }
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.isPowered = compound.m_128471_("isPowered");
        this.openCount = compound.m_128451_("openCount");
        this.canNotGenerate = compound.m_128471_("canNotGenerate");
        if (compound.m_128441_("notebook_page")) {
            this.notebookPageTag = compound.m_128469_("notebook_page");
        }
        super.m_142466_(compound);
    }

    @Override
    public void regenerateStargate(IStargateGenerator.PlacementConfig pConfig) {
        ILinkable linkable;
        StargateOrlinBaseBE stargateOrlinBaseBE;
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        JSG.logger.info("Regenerating Orlin's stargate at {} in {}", (Object)this.m_58899_(), (Object)this.f_58857_.m_46472_().m_135782_());
        pConfig.world = this.f_58857_;
        pConfig.gateBasePos = this.m_58899_();
        pConfig.gateFacing = this.mergeHelper.horizontalFacing;
        pConfig.gateVerticalFacing = this.mergeHelper.verticalFacing;
        pConfig.gateType = this.getStargateType();
        pConfig.overlay = this.getBiomeOverlayWithOverride(true);
        if (this.f_58857_.f_46441_.m_188501_() < 0.3f) {
            pConfig.upgrades.add(IStargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_TYPE);
        }
        if ((stargateOrlinBaseBE = this) instanceof ILinkable && (linkable = (ILinkable)((Object)stargateOrlinBaseBE)).isLinked()) {
            pConfig.dhdPos = linkable.getLinkedPos();
            if (this.f_58857_.f_46441_.m_188501_() < 0.3f) {
                pConfig.upgrades.add(IStargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_DHD);
            }
            pConfig.dhdFluid = (int)(((float)JSGConfig.DialHomeDevice.fluidCapacity.get() - (float)JSGConfig.DialHomeDevice.fluidCapacity.get() * 0.1f) * this.f_58857_.f_46441_.m_188501_() + (float)JSGConfig.DialHomeDevice.fluidCapacity.get() * 0.1f);
        }
        StargateGenerator generator = new StargateGenerator();
        generator.setStargateEnergyInternalSmart(pConfig, (int)((float)JSGConfig.Stargate.stargateEnergyStorage.get() * this.f_58857_.f_46441_.m_188501_()));
        generator.generateStargate(pConfig, false);
        this.generateAddresses(true);
        this.m_6596_();
    }
}

