/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.command.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.config.ingame.option.StargateConfigOptions;
import dev.tauri.jsg.api.helper.RayTraceHelper;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import dev.tauri.jsg.api.stargate.type.StargateType;
import dev.tauri.jsg.api.stargate.type.StargateTypes;
import dev.tauri.jsg.api.util.GeneratedStargate;
import dev.tauri.jsg.api.util.IStargateGenerator;
import dev.tauri.jsg.command.JSGAbstractCommand;
import dev.tauri.jsg.command.JSGCommand;
import dev.tauri.jsg.helpers.BlockPosHelper;
import dev.tauri.jsg.worldgen.generator.StargateGenerator;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CommandBuildGate
extends JSGAbstractCommand {
    public CommandBuildGate() {
        super(JSGCommand.JSG_COMMAND_BASE);
    }

    @Override
    public List<String> getAliases() {
        return List.of("billgates");
    }

    @Override
    public String getName() {
        return "buildgate";
    }

    @Override
    public String getGeneralUsage() {
        return "buildgate <MILKYWAY|PEGASUS|UNIVERSE|TOLLAN|MOVIE|ORLIN|?>";
    }

    @Override
    public String getDescription() {
        return "Builds gate at place you are looking at.";
    }

    @Override
    @ParametersAreNonnullByDefault
    public ArgumentBuilder<CommandSourceStack, ?> registerArguments(ArgumentBuilder<CommandSourceStack, ?> command) {
        return command.then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (StargateType type : StargateType.values()) {
                if (!Objects.equals(builder.getRemainingLowerCase(), "") && !type.textId.toLowerCase().startsWith(builder.getRemainingLowerCase())) continue;
                builder.suggest(type.textId);
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            String type = StringArgumentType.getString((CommandContext)ctx, (String)"type");
            StargateType typeEnum = StargateType.valueOf(type);
            if (typeEnum == null) {
                this.baseCommand.sendErrorMess((CommandSourceStack)ctx.getSource(), "Specify correct gate type!", new Object[0]);
                return 0;
            }
            ServerPlayer sender = ((CommandSourceStack)ctx.getSource()).m_230896_();
            if (sender == null) {
                this.baseCommand.sendErrorMess((CommandSourceStack)ctx.getSource(), "This command can only be run by a player!", new Object[0]);
                return 0;
            }
            BlockPos pos = BlockPosHelper.getPos(sender.m_20182_());
            BlockPos target = RayTraceHelper.rayTracePos((Player)sender, 10);
            if (target != null) {
                pos = typeEnum == StargateTypes.ORLIN ? target.m_7494_() : target.m_7495_();
            }
            IStargateGenerator.PlacementConfig genCfg = new IStargateGenerator.PlacementConfig();
            Direction direction = sender.m_6350_().m_122424_();
            ItemStack item = sender.m_21205_();
            genCfg.overlay = BiomeOverlayRegistry.getBiomeOverlayByItem(item);
            Level world = sender.m_9236_();
            genCfg.gateBasePos = pos;
            genCfg.gateFacing = direction;
            genCfg.world = world;
            genCfg.gateType = typeEnum;
            genCfg.stargateConfig = config -> {
                config.getOption(StargateConfigOptions.Classic.MAX_CAPACITORS).ifPresent(option -> option.parseAndSetValue(genCfg.capacitors.size()));
                return config;
            };
            genCfg.upgrades.add(IStargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_MW);
            genCfg.upgrades.add(IStargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_PEG);
            genCfg.upgrades.add(IStargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_UNI);
            genCfg.upgrades.add(IStargateGenerator.StargateUpgradesEnum.UPGRADE_IRIS_CREATIVE);
            genCfg.upgrades.add(IStargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_STARGATE);
            StargateGenerator generator = new StargateGenerator();
            generator.setStargateEnergyInternalSmart(genCfg, JSGConfig.Stargate.stargateEnergyStorage.get());
            GeneratedStargate result = generator.generateStargate(genCfg);
            if (result == null) {
                this.baseCommand.sendErrorMess((CommandSourceStack)ctx.getSource(), "Error while generating stargate!", new Object[0]);
                return 0;
            }
            this.baseCommand.sendSuccessMess((CommandSourceStack)ctx.getSource(), "Stargate generated successfully!", new Object[0]);
            return 1;
        })).executes(ctx -> {
            this.baseCommand.sendErrorMess((CommandSourceStack)ctx.getSource(), "You need to specify gate type!", new Object[0]);
            return 0;
        });
    }
}

