/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.command.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.tauri.jsg.api.helper.RayTraceHelper;
import dev.tauri.jsg.api.util.blockentity.IPreparable;
import dev.tauri.jsg.command.JSGAbstractCommand;
import dev.tauri.jsg.command.JSGCommand;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class CommandPrepare
extends JSGAbstractCommand {
    public CommandPrepare() {
        super(JSGCommand.JSG_COMMAND_BASE);
    }

    @Override
    public String getName() {
        return "prepare";
    }

    @Override
    public String getGeneralUsage() {
        return "prepare [argument] [x y z]";
    }

    @Override
    public String getDescription() {
        return "Prepares block entity for saving to NBT structure.";
    }

    @Override
    public ArgumentBuilder<CommandSourceStack, ?> registerArguments(ArgumentBuilder<CommandSourceStack, ?> command) {
        return command.then(((RequiredArgumentBuilder)Commands.m_82129_((String)"argument", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).executes(this.getMainCommand(true, true)))).executes(this.getMainCommand(false, true))).then(Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).executes(this.getMainCommand(true, false))).executes(this.getMainCommand(false, false));
    }

    public Command<CommandSourceStack> getMainCommand(boolean pos, boolean argument) {
        return ctx -> this.prepareBE(pos ? BlockPosArgument.m_118242_((CommandContext)ctx, (String)"position") : null, argument ? StringArgumentType.getString((CommandContext)ctx, (String)"argument") : null, (CommandContext<CommandSourceStack>)ctx);
    }

    private int prepareBE(@Nullable BlockPos position, @Nullable String argument, @NotNull CommandContext<CommandSourceStack> ctx) {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
        if (player == null) {
            this.baseCommand.sendErrorMess((CommandSourceStack)ctx.getSource(), "commands.generic.player_only", new Object[0]);
            return 0;
        }
        if (position == null && (position = RayTraceHelper.rayTracePos((Player)player, 8)) == null) {
            this.baseCommand.sendErrorMess((CommandSourceStack)ctx.getSource(), "commands.prepare.not_preparable", new Object[0]);
            return 0;
        }
        BlockEntity be = player.m_9236_().m_7702_(position);
        if (!(be instanceof IPreparable)) {
            this.baseCommand.sendErrorMess((CommandSourceStack)ctx.getSource(), "commands.prepare.not_preparable", new Object[0]);
            return 0;
        }
        IPreparable preparable = (IPreparable)be;
        if (!preparable.prepareBE(argument)) {
            this.baseCommand.sendErrorMess((CommandSourceStack)ctx.getSource(), "commands.prepare.error", new Object[0]);
            return 0;
        }
        this.baseCommand.sendSuccessMess((CommandSourceStack)ctx.getSource(), "commands.prepare.success", new Object[0]);
        return 1;
    }
}

