/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.command.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.helper.DimensionsHelper;
import dev.tauri.jsg.api.helper.RayTraceHelper;
import dev.tauri.jsg.api.stargate.rig.IRIGWave;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.command.JSGAbstractCommand;
import dev.tauri.jsg.command.JSGCommand;
import dev.tauri.jsg.helpers.LinkingHelper;
import dev.tauri.jsg.registry.tags.JSGBlockTags;
import dev.tauri.jsg.stargate.rig.RIGWave;
import dev.tauri.jsg.stargate.rig.StargateRIGManager;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class CommandRIGActivate
extends JSGAbstractCommand {
    public CommandRIGActivate() {
        super(JSGCommand.JSG_COMMAND_BASE);
    }

    @Override
    public String getName() {
        return "rig";
    }

    @Override
    public String getGeneralUsage() {
        return "rig [x y z [dim]] [waveName] [opensIris]";
    }

    @Override
    public String getDescription() {
        return "Spawns new RIG on gate at target pos";
    }

    @Override
    public ArgumentBuilder<CommandSourceStack, ?> registerArguments(ArgumentBuilder<CommandSourceStack, ?> command) {
        return command.then(Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"dim", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((context, builder) -> {
            for (ResourceKey<Level> dim : DimensionsHelper.getDims()) {
                if (!Objects.equals(builder.getRemainingLowerCase(), "") && !dim.m_135782_().toString().toLowerCase().startsWith(builder.getRemainingLowerCase())) continue;
                builder.suggest(dim.m_135782_().toString());
            }
            return builder.buildFuture();
        }).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"wave", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"opensIris", (ArgumentType)BoolArgumentType.bool()).executes(this.getMainCommand(true, true, true, true)))).suggests((context, builder) -> {
            for (String waveId : StargateRIGManager.getWaves()) {
                if (!Objects.equals(builder.getRemainingLowerCase(), "") && !waveId.toLowerCase().startsWith(builder.getRemainingLowerCase())) continue;
                builder.suggest(waveId);
            }
            return builder.buildFuture();
        }).executes(this.getMainCommand(true, true, true, false)))).executes(this.getMainCommand(true, true, false, false)))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"wave", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"opensIris", (ArgumentType)BoolArgumentType.bool()).executes(this.getMainCommand(false, false, true, true)))).suggests((context, builder) -> {
            for (String waveId : StargateRIGManager.getWaves()) {
                if (!Objects.equals(builder.getRemainingLowerCase(), "") && !waveId.toLowerCase().startsWith(builder.getRemainingLowerCase())) continue;
                builder.suggest(waveId);
            }
            return builder.buildFuture();
        }).executes(this.getMainCommand(false, false, true, false))).executes(this.getMainCommand(false, false, false, false));
    }

    public Command<CommandSourceStack> getMainCommand(boolean pos, boolean dim, boolean wave, boolean openIris) {
        return ctx -> this.activateRIG(pos ? BlockPosArgument.m_118242_((CommandContext)ctx, (String)"position") : null, dim, wave, openIris, (CommandContext<CommandSourceStack>)ctx);
    }

    private int activateRIG(@Nullable BlockPos position, boolean dim, boolean waveId, boolean openIris, @NotNull CommandContext<CommandSourceStack> ctx) {
        try {
            Boolean shouldOpenIris;
            StargateRIGManager rigManager;
            StargateAbstractBaseBE stargate;
            BlockEntity be;
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
            boolean posChanged = false;
            if (!(player != null || position != null && dim)) {
                this.baseCommand.sendErrorMess((CommandSourceStack)ctx.getSource(), "commands.rig.position_empty", new Object[0]);
                return 0;
            }
            ResourceKey<Level> dimension = dim ? DimensionsHelper.getDimension(ResourceLocationArgument.m_107011_(ctx, (String)"dim")) : player.m_9236_().m_46472_();
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81377_().m_129880_(dimension);
            if (level == null) {
                this.baseCommand.sendErrorMess((CommandSourceStack)ctx.getSource(), "commands.rig.unknown_level", new Object[0]);
                return 0;
            }
            if (position == null) {
                posChanged = true;
                position = RayTraceHelper.rayTracePos((Player)player, 5);
            }
            BlockEntity blockEntity = be = position == null ? null : level.m_7702_(position);
            if (!(be instanceof StargateAbstractBaseBE)) {
                if (player == null || !posChanged) {
                    this.baseCommand.sendErrorMess((CommandSourceStack)ctx.getSource(), "commands.rig.not_stargate", new Object[0]);
                    return 0;
                }
                stargate = LinkingHelper.findClosestTile((Level)level, player.m_20183_(), JSGBlockTags.ALL_STARGATE_BASES, StargateAbstractBaseBE.class, 20, 20);
                if (stargate == null) {
                    this.baseCommand.sendErrorMess((CommandSourceStack)ctx.getSource(), "commands.rig.not_stargate", new Object[0]);
                    return 0;
                }
            } else {
                StargateAbstractBaseBE sg = (StargateAbstractBaseBE)be;
                stargate = sg;
            }
            if ((rigManager = stargate.getRIGManager()).isActive()) {
                this.baseCommand.sendErrorMess((CommandSourceStack)ctx.getSource(), "commands.rig.already_active", new Object[0]);
                return 0;
            }
            Optional wave = waveId ? StargateRIGManager.getWave(StringArgumentType.getString(ctx, (String)"wave")) : Optional.empty();
            Boolean bl = shouldOpenIris = openIris ? Boolean.valueOf(BoolArgumentType.getBool(ctx, (String)"opensIris")) : null;
            if (wave.isPresent()) {
                rigManager.spawnNewIncoming((IRIGWave)wave.get(), ((RIGWave)wave.get()).chevronsToDial, shouldOpenIris);
            } else {
                rigManager.generateNewIncoming(shouldOpenIris);
            }
            return 1;
        }
        catch (Exception e) {
            JSG.logger.error("e", e);
            return 0;
        }
    }
}

