/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.command.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import dev.tauri.jsg.api.helper.BlockHelper;
import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolUsage;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolUtil;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.command.JSGCommand;
import dev.tauri.jsg.command.commands.AbstractStargateCommand;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.NotNull;

public class CommandSGSetAddress
extends AbstractStargateCommand {
    public CommandSGSetAddress() {
        super(JSGCommand.JSG_COMMAND_BASE);
    }

    @Override
    public String getName() {
        return "sgsetaddress";
    }

    @Override
    public String getGeneralUsage() {
        return "sgsetaddress [x y z] <map=> *glyphs";
    }

    @Override
    public String getDescription() {
        return "Sets the address of the specified gate.";
    }

    @Override
    public ArgumentBuilder<CommandSourceStack, ?> getMainCommandPart(boolean pos) {
        return Commands.m_82129_((String)"map", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (AbstractSymbolType<?> type : AbstractSymbolType.values(SymbolUsage.STARGATES)) {
                if (!Objects.equals(builder.getRemainingLowerCase(), "") && !type.getId().toLowerCase().startsWith(builder.getRemainingLowerCase())) continue;
                builder.suggest(type.getId());
            }
            return builder.buildFuture();
        }).then(this.getGlyphArguments(1, (Command<CommandSourceStack>)((Command)ctx -> this.setAddress(pos ? BlockPosArgument.m_118242_((CommandContext)ctx, (String)"position") : null, StringArgumentType.getString((CommandContext)ctx, (String)"map"), List.of(StringArgumentType.getString((CommandContext)ctx, (String)"glyph1"), StringArgumentType.getString((CommandContext)ctx, (String)"glyph2"), StringArgumentType.getString((CommandContext)ctx, (String)"glyph3"), StringArgumentType.getString((CommandContext)ctx, (String)"glyph4"), StringArgumentType.getString((CommandContext)ctx, (String)"glyph5"), StringArgumentType.getString((CommandContext)ctx, (String)"glyph6"), StringArgumentType.getString((CommandContext)ctx, (String)"glyph7"), StringArgumentType.getString((CommandContext)ctx, (String)"glyph8")), (CommandContext<CommandSourceStack>)ctx))));
    }

    private SuggestionProvider<CommandSourceStack> getSymbolSuggestion() {
        return (context, builder) -> {
            try {
                String symbolTypeString = StringArgumentType.getString((CommandContext)context, (String)"map");
                if (symbolTypeString == null) {
                    return builder.buildFuture();
                }
                AbstractSymbolType<?> symbolType = AbstractSymbolType.byId(symbolTypeString.toLowerCase());
                if (symbolType == null) {
                    return builder.buildFuture();
                }
                StargateAddressDynamic address = new StargateAddressDynamic(symbolType);
                try {
                    String s;
                    for (int i = 1; i <= 8 && (s = StringArgumentType.getString((CommandContext)context, (String)("glyph" + i))) != null; ++i) {
                        SymbolInterface symbol = SymbolUtil.getSymbolFromNameIndex(symbolType, s.replaceAll("_", " "));
                        if (symbol == null || !symbol.isValidForAddress()) continue;
                        address.addSymbol(symbol);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (SymbolInterface symbol : symbolType.getValues()) {
                    if (!symbol.isValidForAddress() || address.contains(symbol)) continue;
                    String name = symbol.getEnglishName().replaceAll(" ", "_");
                    if (!Objects.equals(builder.getRemainingLowerCase(), "") && !name.toLowerCase().startsWith(builder.getRemainingLowerCase())) continue;
                    builder.suggest(name);
                }
                return builder.buildFuture();
            }
            catch (Exception ignored) {
                return builder.buildFuture();
            }
        };
    }

    private ArgumentBuilder<CommandSourceStack, ?> getGlyphArguments(int glyph, Command<CommandSourceStack> cmd) {
        RequiredArgumentBuilder last = Commands.m_82129_((String)("glyph" + glyph), (ArgumentType)StringArgumentType.word()).suggests(this.getSymbolSuggestion());
        if (glyph >= 8) {
            return last.executes(cmd);
        }
        ArgumentBuilder<CommandSourceStack, ?> next = this.getGlyphArguments(glyph + 1, cmd);
        last.then(next);
        return last;
    }

    private int setAddress(@Nullable BlockPos position, String map, List<String> glyphs, @NotNull CommandContext<CommandSourceStack> ctx) {
        Stargate<?> stargate = this.getStargate(position, ctx);
        if (stargate == null) {
            return 0;
        }
        if (map == null || glyphs == null) {
            this.baseCommand.sendErrorMess((CommandSourceStack)ctx.getSource(), "commands.sgsetaddress.noaddressspace", new Object[0]);
            return 0;
        }
        AbstractSymbolType<?> symbolType = AbstractSymbolType.byId(map.toLowerCase());
        if (symbolType == null) {
            this.baseCommand.sendErrorMess((CommandSourceStack)ctx.getSource(), "commands.sgsetaddress.noaddressspace", new Object[0]);
            return 0;
        }
        StargateAddressDynamic address = new StargateAddressDynamic(symbolType);
        int i = 0;
        for (String s : glyphs) {
            if (++i > 8) break;
            SymbolInterface symbol = SymbolUtil.getSymbolFromNameIndex(symbolType, s.replaceAll("_", " "));
            if (symbol == null || !symbol.isValidForAddress()) {
                this.baseCommand.sendErrorMess((CommandSourceStack)ctx.getSource(), "commands.sgsetaddress.wrongsymbol", i);
                return 0;
            }
            if (address.contains(symbol)) {
                this.baseCommand.sendErrorMess((CommandSourceStack)ctx.getSource(), "commands.sgsetaddress.duplicatesymbol", i);
                return 0;
            }
            address.addSymbol(symbol);
        }
        if (i < 8 || address.getSize() < 8) {
            this.baseCommand.sendErrorMess((CommandSourceStack)ctx.getSource(), "commands.sgsetaddress.wrongaddress", new Object[0]);
            return 0;
        }
        stargate.setGateAddress(symbolType, address.toImmutable());
        this.baseCommand.sendSuccessMess((CommandSourceStack)ctx.getSource(), "commands.sgsetaddress.success", BlockHelper.blockPosToBetterString(position), address.toString());
        return 1;
    }
}

