/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.config.stargate;

import dev.tauri.jsg.api.config.IJSONConfigEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class StargateDimensionConfigEntry
implements IJSONConfigEntry {
    public String name;
    public int distance;
    public ArrayList<String> groups;
    public Map<String, Map<String, String>> origins;
    public boolean hasStargate;
    public double lightingBoltChance;
    public boolean isBlackHoleDim;

    public StargateDimensionConfigEntry(String name, boolean hasStargate, int distance, ArrayList<String> groups) {
        this(name, hasStargate, distance, groups, 5.0E-4f, false);
    }

    public StargateDimensionConfigEntry(String name, boolean hasStargate, int distance, ArrayList<String> groups, @Nonnull Map<String, Map<String, String>> origins) {
        this(name, hasStargate, distance, groups, origins, 5.0E-4f, false);
    }

    public StargateDimensionConfigEntry(String name, boolean hasStargate, int distance, ArrayList<String> groups, double lightingBoltChance, boolean isBlackHoleDim) {
        this(name, hasStargate, distance, groups, new HashMap<String, Map<String, String>>(), lightingBoltChance, isBlackHoleDim);
    }

    public StargateDimensionConfigEntry(String name, boolean hasStargate, int distance, ArrayList<String> groups, @Nonnull Map<String, Map<String, String>> origins, double lightingBoltChance, boolean isBlackHoleDim) {
        this.name = name;
        this.distance = distance;
        this.groups = groups;
        this.hasStargate = hasStargate;
        this.origins = origins;
        this.lightingBoltChance = lightingBoltChance;
        this.isBlackHoleDim = isBlackHoleDim;
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
    }

    public String toString() {
        return "[name=" + this.name + ", distance=" + this.distance + ", groups: '" + this.groups.toString() + "']";
    }

    public boolean isGroupEqual(StargateDimensionConfigEntry other) {
        if (other == this) {
            return true;
        }
        if (this.groups == null) {
            return false;
        }
        if (other.groups == null) {
            return false;
        }
        if (this.groups.isEmpty() || other.groups.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.groups.size(); ++i) {
            if (!other.groups.contains(this.groups.get(i))) continue;
            return true;
        }
        return this.groups.equals(other.groups);
    }

    @Override
    public String getId() {
        return this.name;
    }
}

