/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.effect;

import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.effect.StargateWormholeType;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.effect.StargateWormholeEffectToClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
@ParametersAreNonnullByDefault
public class StargateWormholeHandler {
    public static final Map<UUID, Long> WORMHOLE_ANIMATION_END_MAP = new HashMap<UUID, Long>();
    public static final Map<UUID, PlaceEntityInterface> PLAYER_PLACER_INTERFACES = new HashMap<UUID, PlaceEntityInterface>();

    public static void handle(ServerPlayer sp, PlaceEntityInterface placer, StargateWormholeType type, int length) {
        if (!JSGConfig.Stargate.enableTravelAnimation.get()) {
            placer.place(newSp -> {});
            return;
        }
        long time = System.currentTimeMillis();
        WORMHOLE_ANIMATION_END_MAP.put(sp.m_20148_(), time + (long)length * 1000L);
        PLAYER_PLACER_INTERFACES.put(sp.m_20148_(), placer);
        JSGPacketHandler.sendTo(new StargateWormholeEffectToClient(false, type, length), sp);
        sp.m_6842_(true);
        sp.m_20331_(true);
        sp.f_19794_ = true;
        sp.m_150110_().f_35934_ = true;
        sp.m_150110_().f_35938_ = false;
        sp.m_6885_();
        sp.m_6842_(true);
    }

    @SubscribeEvent
    public static void tick(TickEvent.LevelTickEvent event) {
        if (event.side.isClient()) {
            return;
        }
        MinecraftServer server = event.level.m_7654_();
        if (server == null) {
            return;
        }
        ArrayList<UUID> toDelete = new ArrayList<UUID>();
        for (Map.Entry<UUID, Long> t : WORMHOLE_ANIMATION_END_MAP.entrySet()) {
            if (System.currentTimeMillis() < t.getValue()) continue;
            toDelete.add(t.getKey());
        }
        for (UUID k : toDelete) {
            StargateWormholeHandler.release(server, k);
        }
    }

    @SubscribeEvent
    public static void onJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)entity;
        if (sp.m_20194_() == null) {
            return;
        }
        StargateWormholeHandler.release(sp.m_20194_(), sp);
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)livingEntity;
        if (sp.m_20194_() == null) {
            return;
        }
        StargateWormholeHandler.release(sp.m_20194_(), sp);
    }

    @ParametersAreNonnullByDefault
    public static void release(MinecraftServer server, ServerPlayer sp) {
        StargateWormholeHandler.release(server, sp.m_20148_());
    }

    public static void release(MinecraftServer server, UUID uuid) {
        if (!WORMHOLE_ANIMATION_END_MAP.containsKey(uuid)) {
            return;
        }
        WORMHOLE_ANIMATION_END_MAP.remove(uuid);
        ServerPlayer sp = server.m_6846_().m_11259_(uuid);
        if (sp == null) {
            return;
        }
        PLAYER_PLACER_INTERFACES.get(uuid).place(newSp -> {
            JSGPacketHandler.sendTo(new StargateWormholeEffectToClient(true, StargateWormholeType.MILKYWAY, 0), newSp);
            newSp.m_6842_(false);
            newSp.m_20331_(false);
            newSp.f_19794_ = false;
            newSp.m_150110_().f_35934_ = false;
            newSp.m_150110_().f_35938_ = true;
            newSp.f_8941_.m_9290_().m_46398_(newSp.m_150110_());
            newSp.m_6885_();
        });
    }

    public static interface PlaceEntityInterface {
        public void place(Consumer<ServerPlayer> var1);
    }
}

