/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.entity.behaviour;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;

public class MineBlockBehavior
extends Behavior<Villager> {
    private static final int MINE_DURATION = 200;
    public static final float SPEED_MODIFIER = 0.5f;
    @Nullable
    private BlockPos orePos;
    private long nextOkStartTime;
    private int timeWorkedSoFar;
    private final List<BlockPos> validOreAround = Lists.newArrayList();
    protected final Predicate<BlockState> isValid;

    public MineBlockBehavior(Predicate<BlockState> isValid) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26363_, (Object)MemoryStatus.VALUE_PRESENT));
        this.isValid = isValid;
    }

    @ParametersAreNonnullByDefault
    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        if (!ForgeEventFactory.getMobGriefingEvent((Level)pLevel, (Entity)pOwner)) {
            return false;
        }
        BlockPos.MutableBlockPos pos = pOwner.m_20183_().m_122032_();
        this.validOreAround.clear();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    pos.m_122169_(pOwner.m_20185_() + (double)i, pOwner.m_20186_() + (double)j, pOwner.m_20189_() + (double)k);
                    if (!this.validPos((BlockPos)pos, pLevel)) continue;
                    this.validOreAround.add(new BlockPos((Vec3i)pos));
                }
            }
        }
        this.orePos = this.getValidBlock(pLevel);
        return this.orePos != null;
    }

    @Nullable
    private BlockPos getValidBlock(ServerLevel pServerLevel) {
        return this.validOreAround.isEmpty() ? null : this.validOreAround.get(pServerLevel.m_213780_().m_188503_(this.validOreAround.size()));
    }

    @ParametersAreNonnullByDefault
    private boolean validPos(BlockPos pPos, ServerLevel pServerLevel) {
        return this.isValid.test(pServerLevel.m_8055_(pPos));
    }

    @ParametersAreNonnullByDefault
    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        if (pGameTime > this.nextOkStartTime && this.orePos != null) {
            pEntity.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.orePos));
            pEntity.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget((PositionTracker)new BlockPosTracker(this.orePos), 0.5f, 1));
        }
    }

    @ParametersAreNonnullByDefault
    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        pEntity.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        pEntity.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        this.timeWorkedSoFar = 0;
        this.nextOkStartTime = pGameTime + 40L;
    }

    @ParametersAreNonnullByDefault
    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        if (this.orePos == null || this.orePos.m_203195_((Position)pOwner.m_20182_(), 1.0)) {
            if (this.orePos != null && pGameTime > this.nextOkStartTime) {
                BlockState blockstate = pLevel.m_8055_(this.orePos);
                if (this.isValid.test(blockstate)) {
                    pLevel.m_46953_(this.orePos, true, (Entity)pOwner);
                } else {
                    this.validOreAround.remove(this.orePos);
                    this.orePos = this.getValidBlock(pLevel);
                    if (this.orePos != null) {
                        this.nextOkStartTime = pGameTime + 20L;
                        pOwner.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget((PositionTracker)new BlockPosTracker(this.orePos), 0.5f, 1));
                        pOwner.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.orePos));
                    }
                }
            }
            ++this.timeWorkedSoFar;
        }
    }

    @ParametersAreNonnullByDefault
    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return this.timeWorkedSoFar < 200;
    }
}

