/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.entity.client.boat;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import dev.tauri.jsg.entity.vehicle.JSGBoat;
import dev.tauri.jsg.entity.vehicle.JSGBoatTypeWrapper;
import dev.tauri.jsg.entity.vehicle.JSGChestBoat;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import org.jetbrains.annotations.NotNull;

public class JSGBoatRenderer<T extends Enum<T>>
extends BoatRenderer {
    private final Map<T, Pair<ResourceLocation, ListModel<Boat>>> boatResources;
    public final JSGBoatTypeWrapper<T> boatTypeWrapper;

    public JSGBoatRenderer(String modId, JSGBoatTypeWrapper<T> boatTypeWrapper, EntityRendererProvider.Context pContext, boolean pChestBoat) {
        super(pContext, pChestBoat);
        this.boatTypeWrapper = boatTypeWrapper;
        this.boatResources = (Map)Stream.of(boatTypeWrapper.values).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)new ResourceLocation(modId, this.getTextureLocation(type, pChestBoat)), this.createBoatModel(modId, pContext, type, pChestBoat))));
    }

    private String getTextureLocation(T pType, boolean pChestBoat) {
        return pChestBoat ? "textures/entity/chest_boat/" + ((JSGBoatTypeWrapper.Type)pType).getName() + ".png" : "textures/entity/boat/" + ((JSGBoatTypeWrapper.Type)pType).getName() + ".png";
    }

    private ListModel<Boat> createBoatModel(String modId, EntityRendererProvider.Context pContext, T pType, boolean pChestBoat) {
        ModelLayerLocation modellayerlocation = pChestBoat ? ModelLayers.m_233550_((Boat.Type)Boat.Type.OAK) : ModelLayers.m_171289_((Boat.Type)Boat.Type.OAK);
        ModelPart modelpart = pContext.m_174023_(modellayerlocation);
        return pChestBoat ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    public ModelLayerLocation createBoatModelName(String modId, T pType) {
        return JSGBoatRenderer.createLocation(modId, "boat/" + ((JSGBoatTypeWrapper.Type)pType).getName());
    }

    public ModelLayerLocation createChestBoatModelName(String modId, T pType) {
        return JSGBoatRenderer.createLocation(modId, "chest_boat/" + ((JSGBoatTypeWrapper.Type)pType).getName());
    }

    private static ModelLayerLocation createLocation(String modId, String pPath) {
        return new ModelLayerLocation(new ResourceLocation(modId, pPath), "main");
    }

    @NotNull
    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(@NotNull Boat boat) {
        if (boat instanceof JSGBoat) {
            JSGBoat modBoat = (JSGBoat)boat;
            return this.boatResources.get(modBoat.getCustomVariant());
        }
        if (boat instanceof JSGChestBoat) {
            JSGChestBoat modChestBoatEntity = (JSGChestBoat)boat;
            return this.boatResources.get(modChestBoatEntity.getCustomVariant());
        }
        return null;
    }
}

