/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.helpers;

import dev.tauri.jsg.block.cauldron.JSGFluidCauldron;
import dev.tauri.jsg.item.JSGBucketItem;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class FluidHelper {
    private final Supplier<DeferredRegister<Fluid>> fluidRegister;
    private final Supplier<DeferredRegister<FluidType>> fluidTypeRegister;
    private final Supplier<DeferredRegister<Item>> itemRegister;
    private final Supplier<DeferredRegister<Block>> blockRegister;

    public FluidHelper(Supplier<DeferredRegister<Fluid>> fluidRegister, Supplier<DeferredRegister<FluidType>> fluidTypeRegister, Supplier<DeferredRegister<Item>> itemRegister, Supplier<DeferredRegister<Block>> blockRegister) {
        this.fluidRegister = fluidRegister;
        this.fluidTypeRegister = fluidTypeRegister;
        this.itemRegister = itemRegister;
        this.blockRegister = blockRegister;
    }

    public MoltenFluid createGenericFluid(final String name, final int color) {
        RegistryObject ft = this.fluidTypeRegister.get().register(name, () -> new FluidType(FluidType.Properties.create().density(100000).canSwim(false).rarity(Rarity.RARE).supportsBoating(false).viscosity(100000).descriptionId("fluid.jsg." + name)){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){

                    public ResourceLocation getStillTexture() {
                        return new ResourceLocation("jsg", "block/fluid/" + name + "_still");
                    }

                    public ResourceLocation getFlowingTexture() {
                        return new ResourceLocation("jsg", "block/fluid/" + name + "_flow");
                    }

                    @NotNull
                    public ResourceLocation getOverlayTexture() {
                        return new ResourceLocation("misc/underwater");
                    }

                    public int getTintColor() {
                        return color;
                    }
                });
            }
        });
        return new MoltenFluid(this, (RegistryObject<FluidType>)ft, name);
    }

    public static boolean isLiquidBlock(BlockState state) {
        return state.m_278721_();
    }

    public static class MoltenFluid {
        public RegistryObject<FluidType> type;
        public RegistryObject<FlowingFluid> still;
        public RegistryObject<FlowingFluid> flowing;
        public RegistryObject<Item> bucket;
        public RegistryObject<LiquidBlock> block;
        public RegistryObject<JSGFluidCauldron> cauldron;
        public final Map<Item, CauldronInteraction> cauldronInteractionMap = CauldronInteraction.m_175617_();
        public ForgeFlowingFluid.Properties properties;
        public String name;

        public MoltenFluid(FluidHelper helper, RegistryObject<FluidType> type, String name) {
            this.type = type;
            this.name = name;
            this.still = helper.fluidRegister.get().register(name + "_still", () -> new ForgeFlowingFluid.Source(this.getProps()));
            this.flowing = helper.fluidRegister.get().register(name + "_flowing", () -> new ForgeFlowingFluid.Flowing(this.getProps()));
            this.block = helper.blockRegister.get().register(name, () -> new LiquidBlock(this.still, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283927_).m_280170_().m_60910_().m_60978_(100.0f).m_278166_(PushReaction.DESTROY).m_222994_().m_278788_().m_60918_(SoundType.f_279557_)));
            this.bucket = helper.itemRegister.get().register(name + "_bucket", () -> new JSGBucketItem((Supplier<? extends Fluid>)this.still, new Item.Properties().m_41487_(1).m_41495_(Items.f_42446_)));
            this.cauldron = helper.blockRegister.get().register(name + "_cauldron", () -> new JSGFluidCauldron(this.cauldronInteractionMap));
            this.properties = new ForgeFlowingFluid.Properties(type, this.still, this.flowing).bucket(this.bucket).block(this.block).slopeFindDistance(2).levelDecreasePerBlock(2);
        }

        public ForgeFlowingFluid.Properties getProps() {
            return this.properties;
        }

        public Fluid get() {
            return (Fluid)this.still.get();
        }
    }
}

