/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.helpers;

import com.mojang.blaze3d.platform.InputConstants;
import dev.tauri.jsg.api.util.I18n;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class ItemHelper {
    public static void applyGenericToolTip(String itemName, List<Component> components, TooltipFlag tooltipFlag) {
        ItemHelper.applyToolTip(List.of(Component.m_237115_((String)(itemName + ".tooltip")).m_130940_(ChatFormatting.GRAY)), I18n.getAdvancedTooltip(itemName + ".tooltip.extended", (i, line) -> line.m_130940_(ChatFormatting.GRAY)), components, tooltipFlag);
    }

    public static void applyToolTip(@Nullable List<Component> tooltip, @Nullable I18n.AdvancedTooltip tooltipAdvanced, List<Component> components, TooltipFlag tooltipFlag) {
        if (tooltip == null) {
            return;
        }
        int key = 340;
        components.addAll(tooltip);
        boolean isKeyDown = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key);
        if ((isKeyDown || tooltipFlag.m_7050_()) && tooltipAdvanced != null && tooltipAdvanced.formatLines() != null) {
            int width = tooltipAdvanced.getWidth() + 2;
            components.add((Component)Component.m_237113_((String)" ".repeat(width)).m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.STRIKETHROUGH));
            components.addAll(tooltipAdvanced.formatLines());
            components.add((Component)Component.m_237113_((String)" ".repeat(width)).m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.STRIKETHROUGH));
        } else if (tooltipAdvanced != null && tooltipAdvanced.formatLines() != null) {
            String text = Component.m_237115_((String)"tooltip.general.hold_shift").getString();
            text = text.replaceAll("%key%", InputConstants.Type.KEYSYM.m_84895_(key).m_84875_().getString());
            components.add((Component)Component.m_237113_((String)text).m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
        }
    }

    @Nullable
    @ParametersAreNonnullByDefault
    public static ItemStack getMapForTarget(TagKey<Structure> structure, Component displayName, MapDecoration.Type destinationType, ServerLevel level, BlockPos origin) {
        BlockPos blockpos = level.m_215011_(structure, origin, 100, true);
        if (blockpos == null) {
            return null;
        }
        ItemStack itemstack = MapItem.m_42886_((Level)level, (int)blockpos.m_123341_(), (int)blockpos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
        MapItem.m_42850_((ServerLevel)level, (ItemStack)itemstack);
        MapItemSavedData.m_77925_((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)destinationType);
        itemstack.m_41714_(displayName);
        return itemstack;
    }
}

