/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.helpers.registry.entity;

import dev.tauri.jsg.entity.client.boat.JSGBoatRendererProvider;
import dev.tauri.jsg.entity.vehicle.JSGBoat;
import dev.tauri.jsg.entity.vehicle.JSGBoatTypeWrapper;
import dev.tauri.jsg.entity.vehicle.JSGChestBoat;
import dev.tauri.jsg.helpers.registry.RegistryHelper;
import dev.tauri.jsg.helpers.registry.RegistryObjectBuilder;
import dev.tauri.jsg.item.core.BoatItem;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class EntityRegistryHelperBoat
extends RegistryHelper<EntityType<?>, BoatEntityBuilder> {
    public final Supplier<DeferredRegister<Item>> itemRegistry;

    public EntityRegistryHelperBoat(Supplier<DeferredRegister<Item>> itemRegistry, Supplier<DeferredRegister<EntityType<?>>> registry) {
        super(registry, BoatEntityBuilder::new);
        this.itemRegistry = itemRegistry;
    }

    public static class BoatEntityBuilder
    extends RegistryObjectBuilder<RegistryHelper<EntityType<?>, ? extends BoatEntityBuilder>> {
        protected Item.Properties properties = new Item.Properties();

        public BoatEntityBuilder(RegistryHelper<EntityType<?>, ? extends BoatEntityBuilder> registryHelper, String name) {
            super(registryHelper, name);
        }

        public BoatEntityBuilder(String name, BoatEntityBuilder other) {
            super(name, other);
        }

        public BoatEntityBuilder setProperties(Item.Properties properties) {
            this.properties = properties;
            return this;
        }

        public <T extends Enum<T>> BoatRegistryObject buildBoats(@NotNull JSGBoatTypeWrapper<T> boatTypeWrapper) {
            RegistryObject entityType = this.registryHelper.registry.get().register(this.name, () -> EntityType.Builder.m_20704_((type, level) -> new JSGBoat(boatTypeWrapper, (EntityType<? extends Boat>)type, level), (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20712_(this.name));
            HashMap itemMap = new HashMap();
            for (Object type : boatTypeWrapper.values) {
                itemMap.put((JSGBoatTypeWrapper.Type)type, ((EntityRegistryHelperBoat)this.registryHelper).itemRegistry.get().register(((JSGBoatTypeWrapper.Type)type).m_7912_().toLowerCase() + "_" + this.name, () -> BoatItem.createNormal(entityType, boatTypeWrapper, type, this.properties, this.tabs)));
            }
            return new BoatRegistryObject(entityType, new JSGBoatRendererProvider.Normal(boatTypeWrapper), itemMap);
        }

        public <T extends Enum<T>> ChestBoatRegistryObject buildChestBoats(@NotNull JSGBoatTypeWrapper<T> boatTypeWrapper) {
            RegistryObject entityType = this.registryHelper.registry.get().register(this.name, () -> EntityType.Builder.m_20704_((type, level) -> new JSGChestBoat(boatTypeWrapper, (EntityType<? extends ChestBoat>)type, level), (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20712_(this.name));
            HashMap itemMap = new HashMap();
            for (Object type : boatTypeWrapper.values) {
                itemMap.put((JSGBoatTypeWrapper.Type)type, ((EntityRegistryHelperBoat)this.registryHelper).itemRegistry.get().register(((JSGBoatTypeWrapper.Type)type).m_7912_().toLowerCase() + "_" + this.name, () -> BoatItem.createChest(entityType, boatTypeWrapper, type, this.properties, this.tabs)));
            }
            return new ChestBoatRegistryObject(entityType, new JSGBoatRendererProvider.Chest(boatTypeWrapper), itemMap);
        }
    }

    public record ChestBoatRegistryObject(RegistryObject<EntityType<JSGChestBoat<?>>> entity, JSGBoatRendererProvider rendererProvider, Map<JSGBoatTypeWrapper.Type, RegistryObject<BoatItem<?>>> item) {
    }

    public record BoatRegistryObject(RegistryObject<EntityType<JSGBoat<?>>> entity, JSGBoatRendererProvider rendererProvider, Map<JSGBoatTypeWrapper.Type, RegistryObject<BoatItem<?>>> item) {
    }
}

