/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.integration;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.integration.Integrations;
import dev.tauri.jsg.integration.cctweaked.CCIntegrationWrapper;
import dev.tauri.jsg.integration.oc2.OCIntegrationWrapper;
import dev.tauri.jsg.integration.oculus.OculusAPIWrapper;
import dev.tauri.jsg.integration.tconstruct.TConstructIntegration;
import net.minecraftforge.fml.ModList;

public class InternalIntegrations {
    public static void tryLoad() {
        for (Integrations i : Integrations.values()) {
            try {
                if (i.modNames.stream().anyMatch(name -> ModList.get().isLoaded(name))) {
                    JSG.logger.info("{} found and connection is enabled... Connecting...", (Object)i.name);
                    i.isLoaded = true;
                    for (Integrations.Loader t : i.onLoad) {
                        t.run();
                    }
                    JSG.logger.info("Successfully connected into {}!", (Object)i.name);
                    continue;
                }
                i.isLoaded = false;
                for (Integrations.Loader t : i.onNotLoaded) {
                    t.run();
                }
            }
            catch (Exception e) {
                JSG.logger.error("Exception loading {} wrapper", (Object)i.name, (Object)e);
            }
        }
    }

    static {
        Integrations.OC2.addOnLoad(() -> {
            JSG.ocWrapper = (OCIntegrationWrapper)Class.forName("dev.tauri.jsg.integration.oc2.OCIntegrationLoaded").getConstructor(new Class[0]).newInstance(new Object[0]);
        }).addOnNotLoaded(() -> {
            JSG.ocWrapper = (OCIntegrationWrapper)Class.forName("dev.tauri.jsg.integration.oc2.OCIntegrationNotLoaded").getConstructor(new Class[0]).newInstance(new Object[0]);
        });
        Integrations.CCT.addOnLoad(() -> {
            JSG.ccWrapper = (CCIntegrationWrapper)Class.forName("dev.tauri.jsg.integration.cctweaked.CCIntegrationLoaded").getConstructor(new Class[0]).newInstance(new Object[0]);
        }).addOnNotLoaded(() -> {
            JSG.ccWrapper = (CCIntegrationWrapper)Class.forName("dev.tauri.jsg.integration.cctweaked.CCIntegrationNotLoaded").getConstructor(new Class[0]).newInstance(new Object[0]);
        });
        Integrations.TCONSTRUCT.addOnLoad(TConstructIntegration::load);
        Integrations.OCULUS.addOnLoad(() -> {
            JSG.oculusWrapper = (OculusAPIWrapper)Class.forName("dev.tauri.jsg.integration.oculus.OculusAPIWrapperLoaded").getConstructor(new Class[0]).newInstance(new Object[0]);
        }).addOnNotLoaded(() -> {
            JSG.oculusWrapper = (OculusAPIWrapper)Class.forName("dev.tauri.jsg.integration.oculus.OculusAPIWrapperNotLoaded").getConstructor(new Class[0]).newInstance(new Object[0]);
        });
    }
}

