/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.integration.cctweaked.methods;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.ObjectArguments;
import dan200.computercraft.api.network.Packet;
import dan200.computercraft.api.network.PacketNetwork;
import dan200.computercraft.api.network.PacketReceiver;
import dan200.computercraft.api.network.PacketSender;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dev.tauri.jsg.api.JSGApi;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.integration.cctweaked.CCDevice;
import dev.tauri.jsg.integration.cctweaked.CCTweakedHelper;
import dev.tauri.jsg.integration.cctweaked.methods.ICCDevice;
import dev.tauri.jsg.util.ClassSeeker;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCCMethods<TILE extends BlockEntity>
implements IPeripheral,
ICCDevice,
PacketReceiver,
PacketSender {
    protected final TILE deviceTile;
    protected final CCDevice device;
    protected final List<IComputerAccess> computers = new ArrayList<IComputerAccess>();

    public AbstractCCMethods(TILE deviceTile, CCDevice device) {
        this.deviceTile = deviceTile;
        this.device = device;
    }

    public Object getTarget() {
        return this.deviceTile;
    }

    @Override
    public void connectToWirelessNetwork() {
        if (this.deviceTile.m_58904_() == null) {
            return;
        }
        if (this.deviceTile.m_58904_().m_7654_() == null) {
            return;
        }
        PacketNetwork wirelessNetwork = ComputerCraftAPI.getWirelessNetwork((MinecraftServer)this.deviceTile.m_58904_().m_7654_());
        wirelessNetwork.addReceiver((PacketReceiver)this);
    }

    @Override
    public void disconnectFromWirelessNetwork() {
        if (this.deviceTile.m_58904_() == null) {
            return;
        }
        if (this.deviceTile.m_58904_().m_7654_() == null) {
            return;
        }
        PacketNetwork wirelessNetwork = ComputerCraftAPI.getWirelessNetwork((MinecraftServer)this.deviceTile.m_58904_().m_7654_());
        wirelessNetwork.removeReceiver((PacketReceiver)this);
    }

    public void attach(IComputerAccess computer) {
        this.computers.add(computer);
    }

    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    @Override
    public void sendSignal(String eventName, Object ... objects) {
        for (IComputerAccess computer : this.computers) {
            int length = objects.length + 1;
            Object[] attachmentObjects = new Object[length];
            attachmentObjects[0] = computer.getAttachmentName();
            System.arraycopy(objects, 0, attachmentObjects, 1, length - 1);
            computer.queueEvent(eventName, attachmentObjects);
        }
        int length = objects.length + 1;
        Object[] attachmentObjects = new Object[length];
        attachmentObjects[0] = eventName;
        System.arraycopy(objects, 0, attachmentObjects, 1, length - 1);
        Packet packet = new Packet(10, 11, (Object)attachmentObjects, (PacketSender)this);
        if (this.deviceTile.m_58904_() == null) {
            return;
        }
        if (this.deviceTile.m_58904_().m_7654_() == null) {
            return;
        }
        PacketNetwork wirelessNetwork = ComputerCraftAPI.getWirelessNetwork((MinecraftServer)this.deviceTile.m_58904_().m_7654_());
        wirelessNetwork.transmitSameDimension(packet, (double)JSGConfig.ComputersIntegration.stargateWirelessRange.get());
    }

    public String getType() {
        return this.device.deviceName;
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other instanceof AbstractCCMethods && this.deviceTile == ((AbstractCCMethods)other).deviceTile;
    }

    public Level getLevel() {
        return this.deviceTile.m_58904_();
    }

    public Vec3 getPosition() {
        return this.deviceTile.m_58899_().m_252807_();
    }

    public String getSenderID() {
        return this.getType();
    }

    public double getRange() {
        return JSGConfig.ComputersIntegration.stargateWirelessRange.get();
    }

    public boolean isInterdimensional() {
        return false;
    }

    public void receiveSameDimension(Packet packet, double distance) {
        Object[] data;
        if (packet.sender() == this) {
            return;
        }
        if (packet.channel() != 11) {
            return;
        }
        Object[] mess = packet.payload();
        if (mess instanceof String) {
            String s = (String)mess;
            mess = new Object[]{s};
        }
        if (mess instanceof Map) {
            Map map = (Map)mess;
            List<Object> list = CCTweakedHelper.getCorrectlyOrderedTableValues(map);
            Object[] array = new Object[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                array[i] = list.get(i);
            }
            mess = array;
        }
        if (!(mess instanceof Object[]) || (data = (Object[])mess).length < 1) {
            return;
        }
        Object[] response = null;
        List<Method> methods = ClassSeeker.getMethodsAnnotatedWith(this.getClass(), LuaFunction.class);
        for (Method m : methods) {
            if (response != null) break;
            if (!m.getName().equalsIgnoreCase(data[0].toString())) continue;
            Object[] params = new Object[data.length - 1];
            if (params.length == 0) {
                try {
                    response = (Object[])m.invoke((Object)this, new Object[0]);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            System.arraycopy(data, 1, params, 0, data.length - 1);
            try {
                response = (Object[])m.invoke((Object)this, null, new ObjectArguments(params));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Packet p = new Packet(packet.replyChannel(), 11, response, (PacketSender)this);
        if (this.deviceTile.m_58904_() == null) {
            return;
        }
        if (this.deviceTile.m_58904_().m_7654_() == null) {
            return;
        }
        PacketNetwork wirelessNetwork = ComputerCraftAPI.getWirelessNetwork((MinecraftServer)this.deviceTile.m_58904_().m_7654_());
        wirelessNetwork.transmitSameDimension(p, (double)JSGConfig.ComputersIntegration.stargateWirelessRange.get());
    }

    public void receiveDifferentDimension(Packet packet) {
    }

    @LuaFunction(mainThread=true)
    public final Object[] getJSGVersion() {
        return new Object[]{JSGApi.MOD_VERSION};
    }
}

