/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.integration.jei;

import dev.tauri.jsg.block.cauldron.CauldronRecipe;
import dev.tauri.jsg.integration.jei.JEIAdvancedGuiHandler;
import dev.tauri.jsg.integration.jei.category.CauldronRecipeType;
import dev.tauri.jsg.integration.jei.category.FluidCauldronRecipeCategory;
import dev.tauri.jsg.integration.jei.category.ItemCauldronRecipeCategory;
import dev.tauri.jsg.integration.jei.recipes.cauldron.FluidCauldronRecipe;
import dev.tauri.jsg.integration.jei.recipes.cauldron.ItemCauldronRecipe;
import dev.tauri.jsg.integration.jei.recipes.crafting.JEINotebookRecipe;
import dev.tauri.jsg.integration.jei.recipes.crafting.JEIPageAndDialerRecipe;
import dev.tauri.jsg.integration.jei.recipes.crafting.JEIUniverseDialerCloneRecipe;
import dev.tauri.jsg.screen.inventory.dialhomedevice.DHDContainerGui;
import dev.tauri.jsg.screen.inventory.stargate.StargateContainerGui;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public final class JEIIntegration
implements IModPlugin {
    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(StargateContainerGui.class, (IGuiContainerHandler)new JEIAdvancedGuiHandler());
        registration.addGuiContainerHandler(DHDContainerGui.class, (IGuiContainerHandler)new JEIAdvancedGuiHandler());
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        registration.addRecipes(RecipeTypes.CRAFTING, JEINotebookRecipe.genAll());
        registration.addRecipes(RecipeTypes.CRAFTING, List.of(new JEIUniverseDialerCloneRecipe(), new JEIPageAndDialerRecipe()));
        for (CauldronRecipe recipe : CauldronRecipe.RECIPES) {
            if (recipe instanceof CauldronRecipe.FluidResult) {
                CauldronRecipe.FluidResult fluidRecipe = (CauldronRecipe.FluidResult)((Object)recipe);
                registration.addRecipes(CauldronRecipeType.CAULDRON_RECIPE_FLUID_TYPE, List.of(new FluidCauldronRecipe(() -> new ItemStack((ItemLike)fluidRecipe.getFluidInput().get()), fluidRecipe.getFluidBaseFluid(), fluidRecipe.getFluidResult())));
            }
            if (!(recipe instanceof CauldronRecipe.ItemResult)) continue;
            CauldronRecipe.ItemResult itemResult = (CauldronRecipe.ItemResult)((Object)recipe);
            registration.addRecipes(CauldronRecipeType.CAULDRON_RECIPE_ITEM_TYPE, List.of(new ItemCauldronRecipe(() -> new ItemStack((ItemLike)itemResult.getItemInput().get()), itemResult.getItemBaseFluid(), itemResult.getItemResult())));
        }
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new ItemCauldronRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidCauldronRecipeCategory(guiHelper)});
    }

    @ParametersAreNonnullByDefault
    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50256_), new RecipeType[]{CauldronRecipeType.CAULDRON_RECIPE_ITEM_TYPE, CauldronRecipeType.CAULDRON_RECIPE_FLUID_TYPE});
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("jsg", "jei_plugin");
    }
}

