/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.integration.jei.recipes.crafting;

import dev.tauri.jsg.api.item.NotebookPageSerialization;
import dev.tauri.jsg.api.stargate.network.address.StargateAddress;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.item.notebook.PageNotebookItemFilled;
import dev.tauri.jsg.recipes.NotebookRecipe;
import dev.tauri.jsg.registry.ItemRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import org.jetbrains.annotations.NotNull;

public class JEINotebookRecipe
extends NotebookRecipe {
    private final List<Ingredient> inputs = new ArrayList<Ingredient>();
    private ItemStack outputs = ItemStack.f_41583_;
    static final ItemStack PAGE1 = JEINotebookRecipe.getRandomPageWithNameColor("Plains", (ResourceKey<Biome>)Biomes.f_48202_);
    static final ItemStack PAGE2 = JEINotebookRecipe.getRandomPageWithNameColor("Tundra", (ResourceKey<Biome>)Biomes.f_48152_);
    static final ItemStack PAGE3 = JEINotebookRecipe.getRandomPageWithNameColor("End", (ResourceKey<Biome>)Biomes.f_48210_, SymbolTypeRegistry.UNIVERSE);
    static final ItemStack NOTEBOOK = JEINotebookRecipe.getNotebookWithPages(1, PAGE1, PAGE2);
    static final ItemStack NOTEBOOK2 = JEINotebookRecipe.getNotebookWithPages(2, PAGE1, PAGE2);

    public static ItemStack getRandomPageWithNameColor(String name, ResourceKey<Biome> biome) {
        return JEINotebookRecipe.getRandomPageWithNameColor(name, biome, SymbolTypeRegistry.MILKYWAY);
    }

    static ItemStack getRandomPageWithNameColor(String name, ResourceKey<Biome> biome, AbstractSymbolType<?> symbolType) {
        ItemStack pageStack = new ItemStack((ItemLike)ItemRegistry.NOTEBOOK_PAGE_FILLED.get(), 1);
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("biome", biome.m_135782_().toString());
        PageNotebookItemFilled.setName(compound, name);
        StargateAddress address = new StargateAddress(symbolType).generate(new Random());
        if (address != null) {
            compound.m_128359_("addressType", NotebookPageSerialization.STARGATES.toString());
            if (address.getSymbolType() != null) {
                compound.m_128359_("symbolType", address.getSymbolType().getId());
            }
            if (address.serializeNBT() != null) {
                compound.m_128365_("address", (Tag)address.serializeNBT());
            }
        }
        compound.m_128405_("originId", -1);
        pageStack.m_41751_(compound);
        return pageStack;
    }

    static ItemStack getNotebookWithPages(int quantity, ItemStack ... pages) {
        ItemStack notebook = new ItemStack((ItemLike)ItemRegistry.NOTEBOOK_ITEM.get(), quantity);
        CompoundTag compound = new CompoundTag();
        ListTag list = new ListTag();
        compound.m_128365_("addressList", (Tag)list);
        notebook.m_41751_(compound);
        for (ItemStack stack : pages) {
            list.add((Object)stack.m_41783_());
        }
        return notebook;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])this.inputs.toArray(new Ingredient[0]));
    }

    @Override
    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack m_5874_(CraftingContainer inv, RegistryAccess pRegistryAccess) {
        return this.outputs.m_41777_();
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.outputs.m_41777_();
    }

    JEINotebookRecipe(NotebookRecipeVariantEnum variant) {
        switch (variant) {
            case TWO_PAGES: {
                this.inputs.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{PAGE1.m_41777_()}));
                this.inputs.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{PAGE2.m_41777_()}));
                this.outputs = NOTEBOOK;
                break;
            }
            case NOTEBOOK_PAGE: {
                this.inputs.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{PAGE1.m_41777_()}));
                this.inputs.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{JEINotebookRecipe.getNotebookWithPages(1, PAGE2).m_41777_()}));
                this.outputs = NOTEBOOK;
                break;
            }
            case NOTEBOOK_BOOK: {
                this.inputs.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{NOTEBOOK.m_41777_()}));
                this.inputs.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42517_)}));
                this.outputs = NOTEBOOK2;
                break;
            }
            case TWO_NOTEBOOKS: {
                this.inputs.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{JEINotebookRecipe.getNotebookWithPages(1, PAGE1.m_41777_())}));
                this.inputs.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{JEINotebookRecipe.getNotebookWithPages(1, PAGE2.m_41777_())}));
                this.outputs = NOTEBOOK2;
            }
        }
    }

    public static List<CraftingRecipe> genAll() {
        ArrayList<CraftingRecipe> list = new ArrayList<CraftingRecipe>();
        for (NotebookRecipeVariantEnum variant : NotebookRecipeVariantEnum.values()) {
            list.add((CraftingRecipe)new JEINotebookRecipe(variant));
        }
        return list;
    }

    static enum NotebookRecipeVariantEnum {
        TWO_PAGES,
        NOTEBOOK_PAGE,
        NOTEBOOK_BOOK,
        TWO_NOTEBOOKS;

    }
}

