/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item;

import dev.tauri.jsg.api.helper.RayTraceHelper;
import dev.tauri.jsg.api.item.JSGItem;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicMemberBE;
import dev.tauri.jsg.helpers.ItemHelper;
import dev.tauri.jsg.helpers.LinkingHelper;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.AdminControllerGuiOpenToClient;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.registry.TabRegistry;
import dev.tauri.jsg.registry.tags.JSGBlockTags;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class AdminControllerItem
extends JSGItem {
    public AdminControllerItem() {
        super(new Item.Properties().m_41487_(1), TabRegistry.TAB_TOOLS);
    }

    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        ItemHelper.applyGenericToolTip(Objects.requireNonNull(ItemRegistry.ADMIN_CONTROLLER.getId()).m_135815_(), components, tooltipFlag);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack != null && newStack != null && oldStack.m_41720_() != newStack.m_41720_();
    }

    @ParametersAreNonnullByDefault
    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean inHand) {
        if (!world.f_46443_ && inHand) {
            if (world.m_46467_() % 10L != 0L) {
                return;
            }
            CompoundTag compound = stack.m_41783_();
            if (compound == null) {
                return;
            }
            if (!compound.m_128441_("linkedGatePos")) {
                return;
            }
            BlockEntity blockEntity = world.m_7702_(BlockPos.m_122022_((long)compound.m_128454_("linkedGatePos")));
            if (!(blockEntity instanceof StargateClassicBaseBE)) {
                return;
            }
            StargateClassicBaseBE gateTile = (StargateClassicBaseBE)blockEntity;
            CompoundTag tag = new CompoundTag();
            gateTile.m_183515_(tag);
            compound.m_128365_("gateNBT", (Tag)tag);
            stack.m_41751_(compound);
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_) {
            StargateClassicBaseBE te = RayTraceHelper.rayTraceTileEntity(player, 20);
            if (te instanceof StargateClassicMemberBE) {
                te = ((StargateClassicMemberBE)((Object)te)).getBaseTile(world);
            }
            if (!(te instanceof StargateClassicBaseBE)) {
                te = LinkingHelper.findClosestTile(world, player.m_20183_(), JSGBlockTags.CLASSIC_STARGATE_BASES, StargateClassicBaseBE.class, 20, 20);
            }
            if (te instanceof StargateClassicBaseBE) {
                StargateClassicBaseBE baseTile = te;
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    if (baseTile.isMerged()) {
                        CompoundTag compound = player.m_21120_(hand).m_41783_();
                        if (compound == null) {
                            compound = new CompoundTag();
                        }
                        compound.m_128356_("linkedGatePos", baseTile.m_58899_().m_121878_());
                        CompoundTag tag = new CompoundTag();
                        baseTile.m_183515_(tag);
                        compound.m_128365_("gateNBT", (Tag)tag);
                        player.m_21120_(hand).m_41751_(compound);
                        JSGPacketHandler.sendTo(new AdminControllerGuiOpenToClient(baseTile.m_58899_(), baseTile.getNetwork()), sp);
                    }
                }
            }
        }
        return super.m_7203_(world, player, hand);
    }
}

