/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item.linkable.dialer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.tauri.jsg.api.helper.ItemRenderingHelper;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import dev.tauri.jsg.item.linkable.HandHeldDeviceRenderer;
import dev.tauri.jsg.item.linkable.dialer.UniverseDialerMode;
import dev.tauri.jsg.item.linkable.dialer.utils.UDModesRenderUtils;
import dev.tauri.jsg.loader.ElementEnum;
import java.awt.Color;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class UniverseDialerBEWLR
extends BlockEntityWithoutLevelRenderer {
    public UniverseDialerBEWLR() {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    }

    @ParametersAreNonnullByDefault
    public void m_108829_(ItemStack itemStack, ItemDisplayContext itemDisplayContext, PoseStack stack, MultiBufferSource bufferSource, int light, int overlay) {
        if (itemStack.m_41782_()) {
            HandHeldDeviceRenderer.currentStack = stack;
            HandHeldDeviceRenderer.source = bufferSource;
            HandHeldDeviceRenderer.light = light;
            stack.m_85836_();
            RenderSystem.enableDepthTest();
            if (itemDisplayContext == ItemDisplayContext.FIXED) {
                stack.m_85836_();
                stack.m_85837_(0.53, 0.5, 0.6);
                stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                stack.m_85841_(0.2f, 0.2f, 0.2f);
            } else {
                boolean mainHand = itemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || itemDisplayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                boolean thirdPerson = itemDisplayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || itemDisplayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                HumanoidArm handSide = mainHand ? HumanoidArm.RIGHT : HumanoidArm.LEFT;
                float partialTicks = Minecraft.m_91087_().getPartialTick();
                if (thirdPerson) {
                    stack.m_85836_();
                    stack.m_85841_(0.3f, 0.3f, 0.3f);
                    stack.m_85837_(2.0, 2.1, 3.0);
                    stack.m_252781_(Axis.f_252529_.m_252977_(-45.0f));
                    stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    stack.m_252781_(Axis.f_252403_.m_252977_(0.0f));
                    stack.m_252781_(Axis.f_252529_.m_252977_(50.0f));
                    stack.m_85837_(0.0, 1.5, 0.3);
                    stack.m_85841_(0.7f, 0.7f, 0.7f);
                } else {
                    HandHeldDeviceRenderer.renderArms(handSide, partialTicks);
                    stack.m_85836_();
                    ItemRenderingHelper.applyBobbing(stack, partialTicks);
                    stack.m_85841_(0.3f, 0.3f, 0.3f);
                    stack.m_85837_(2.0, 2.1, 3.0);
                    stack.m_252781_(Axis.f_252529_.m_252977_(-45.0f));
                    stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    stack.m_252781_(Axis.f_252403_.m_252977_(0.0f));
                }
            }
            CompoundTag compound = itemStack.m_41783_();
            if (compound != null) {
                BiomeOverlayRegistry.BiomeOverlayInstance biomeOverlay = BiomeOverlayRegistry.NORMAL;
                if (compound.m_128441_("biomeOverlay")) {
                    biomeOverlay = BiomeOverlayRegistry.byId(new ResourceLocation(compound.m_128461_("biomeOverlay")));
                }
                ElementEnum.UNIVERSE_DIALER.bindTexture(biomeOverlay).render(stack, bufferSource, light);
                RenderSystem.enableDepthTest();
                stack.m_85836_();
                UniverseDialerMode mode = UniverseDialerMode.valueOf(new ResourceLocation(compound.m_128461_("selectedMode"))).orElse(UniverseDialerMode.getDefault());
                CompoundTag modeTag = mode.getTag(compound);
                boolean notLinked = mode.matchBlocks != null && !modeTag.m_128441_("linkedPos");
                stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                stack.m_85837_(0.65, 0.0, 1.1865);
                stack.m_85841_(1.0f, -1.0f, 1.0f);
                stack.m_85837_(-0.2, 0.8, -1.0);
                stack.m_85836_();
                RenderSystem.enableBlend();
                if (notLinked) {
                    UDModesRenderUtils.drawWaringGlyph(stack, new Color(-1, true));
                }
                HandHeldDeviceRenderer.drawStringWithShadow(0.0f, 0.0f, mode.localize(), true, false);
                HandHeldDeviceRenderer.drawStringWithShadow(-0.7f, 0.0f, mode.next().localize(), false, false);
                RenderSystem.enableDepthTest();
                mode.getScreen().render(itemStack, modeTag, itemDisplayContext, stack, bufferSource, light, overlay);
                RenderSystem.disableBlend();
                stack.m_85849_();
                stack.m_85849_();
            }
            stack.m_85849_();
            stack.m_85849_();
            RenderSystem.disableDepthTest();
        }
    }
}

