/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item.linkable.dialer;

import dev.tauri.jsg.api.item.JSGItem;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import dev.tauri.jsg.api.util.I18n;
import dev.tauri.jsg.helpers.ItemHelper;
import dev.tauri.jsg.item.linkable.dialer.UniverseDialerBEWLR;
import dev.tauri.jsg.item.linkable.dialer.UniverseDialerMode;
import dev.tauri.jsg.item.linkable.dialer.modes.UniverseDialerModes;
import dev.tauri.jsg.registry.TabRegistry;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class UniverseDialerItem
extends JSGItem {
    public static final String C_MODE = "selectedMode";
    public static final String C_MODE_TAG = "_tag";
    public static final String C_BIOME_OVERLAY = "biomeOverlay";

    public UniverseDialerItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON), TabRegistry.TAB_TOOLS);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private static final UniverseDialerBEWLR instance = new UniverseDialerBEWLR();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return instance;
            }
        });
    }

    @ParametersAreNonnullByDefault
    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.f_46443_) {
            return;
        }
        CompoundTag compound = stack.m_41784_();
        boolean changed = false;
        if (!compound.m_128425_(C_MODE, 8)) {
            compound.m_128359_(C_MODE, UniverseDialerMode.getDefault().id.toString());
            changed = true;
        }
        if (world.m_46467_() % 20L == 0L) {
            compound.m_128359_(C_BIOME_OVERLAY, BiomeOverlayRegistry.getUpdatedBiomeOverlay((Level)world, (BlockPos)entity.m_20183_(), List.of(BiomeOverlayRegistry.NORMAL, BiomeOverlayRegistry.FROST)).id.toString());
            changed = true;
        }
        UniverseDialerMode mode = UniverseDialerMode.valueOf(new ResourceLocation(compound.m_128461_(C_MODE))).orElse(UniverseDialerMode.getDefault());
        if (!mode.id.toString().equals(compound.m_128461_(C_MODE))) {
            compound.m_128359_(C_MODE, mode.id.toString());
            changed = true;
        }
        if (changed) {
            stack.m_41751_(compound);
        }
        mode.inventoryTick(stack, mode.getTag(compound), world, entity, itemSlot, isSelected);
    }

    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        ItemHelper.applyGenericToolTip(this.m_5524_(), components, tooltipFlag);
        ListTag list = stack.m_41784_().m_128469_(String.valueOf(UniverseDialerModes.MEMORY.id) + C_MODE_TAG).m_128437_("entries", 10);
        components.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.GRAY) + I18n.format("item.jsg.universe_dialer.saved_gates", list.size()))));
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag compound = list.m_128728_(i);
            if (!compound.m_128441_("name")) continue;
            components.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.AQUA) + compound.m_128461_("name"))));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() != this) {
            return super.m_7203_(world, player, hand);
        }
        CompoundTag compound = stack.m_41784_();
        if (!compound.m_128425_(C_MODE, 8)) {
            return super.m_7203_(world, player, hand);
        }
        UniverseDialerMode mode = UniverseDialerMode.valueOf(new ResourceLocation(compound.m_128461_(C_MODE))).orElse(UniverseDialerMode.getDefault());
        if (!mode.id.toString().equals(compound.m_128461_(C_MODE))) {
            return super.m_7203_(world, player, hand);
        }
        if (mode.onUse(mode.getTag(compound), stack, world, player, hand, player.m_6144_())) {
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.f_46443_);
        }
        return super.m_7203_(world, player, hand);
    }
}

