/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item.linkable.dialer;

import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.util.I18n;
import dev.tauri.jsg.item.linkable.dialer.IUniverseDialerScreen;
import dev.tauri.jsg.item.linkable.dialer.UniverseDialerClientActionEnum;
import dev.tauri.jsg.item.linkable.dialer.utils.UDCommonUtils;
import dev.tauri.jsg.packet.packets.linkable.UniverseDialerActionPacketToServer;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.sound.SoundEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public abstract class UniverseDialerMode {
    public static final String C_LINKED_POS = "linkedPos";
    private static final HashMap<ResourceLocation, UniverseDialerMode> MODES = new HashMap();
    private static UniverseDialerMode lastMode;
    private static UniverseDialerMode firstMode;
    public final ResourceLocation id;
    public final String title;
    @Nullable
    public final TagKey<Block> matchBlocks;
    public final BiPredicate<Level, BlockPos> linkMatchTest;
    private UniverseDialerMode prev;
    private UniverseDialerMode next;

    public UniverseDialerMode(ResourceLocation id, String title) {
        this(id, title, null, (a, b) -> false);
    }

    public UniverseDialerMode(ResourceLocation id, String title, @Nullable TagKey<Block> matchBlocks, BiPredicate<Level, BlockPos> linkMatchTest) {
        this.id = id;
        this.title = title;
        this.matchBlocks = matchBlocks;
        this.linkMatchTest = linkMatchTest;
        MODES.put(id, this);
        if (firstMode == null) {
            firstMode = this;
        }
        if (lastMode == null) {
            lastMode = this;
        }
        UniverseDialerMode.firstMode.prev = this;
        UniverseDialerMode.lastMode.next = this;
        this.prev = lastMode;
        this.next = firstMode;
        lastMode = this;
    }

    @Nonnull
    public abstract IUniverseDialerScreen getScreen();

    @ParametersAreNonnullByDefault
    public void inventoryTick(ItemStack stack, CompoundTag compound, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.f_46443_) {
            return;
        }
        if (this.matchBlocks == null) {
            return;
        }
        if (!isSelected) {
            return;
        }
        if (world.m_46467_() % 20L != 0L) {
            return;
        }
        BlockPos pos = entity.m_20183_();
        int reachSquared = JSGConfig.DialHomeDevice.universeDialerReach.get() * JSGConfig.DialHomeDevice.universeDialerReach.get() * 2;
        if (compound.m_128441_(C_LINKED_POS)) {
            BlockPos tilePos = BlockPos.m_122022_((long)compound.m_128454_(C_LINKED_POS));
            if (!world.m_8055_(tilePos).m_204336_(this.matchBlocks) || tilePos.m_123331_((Vec3i)pos) > (double)reachSquared) {
                compound.m_128473_(C_LINKED_POS);
                this.onLinkUpdated(false, tilePos, compound, stack, (ServerLevel)world, entity);
            }
            return;
        }
        ArrayList<BlockPos> blacklist = new ArrayList<BlockPos>();
        int loop = 0;
        do {
            ++loop;
            BlockPos targetPos = UDCommonUtils.getNearestLinkable(world, pos, blacklist, this);
            if (targetPos == null) break;
            if (this.linkMatchTest.test(world, targetPos)) {
                compound.m_128356_(C_LINKED_POS, targetPos.m_121878_());
                this.onLinkUpdated(true, targetPos, compound, stack, (ServerLevel)world, entity);
                break;
            }
            blacklist.add(targetPos);
        } while (loop < 100);
    }

    @ParametersAreNonnullByDefault
    public void onLinkUpdated(boolean isLinked, BlockPos linkedPos, CompoundTag compound, ItemStack stack, ServerLevel world, Entity entity) {
        if (isLinked && entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            JSGSoundHelper.playSoundToPlayer(sp, SoundEvent.UNIVERSE_DIALER_CONNECTED, entity.m_20183_());
        }
    }

    @ParametersAreNonnullByDefault
    public void handlePacketToServer(UniverseDialerClientActionEnum action, CompoundTag compound, UniverseDialerActionPacketToServer packet, NetworkEvent.Context ctx) {
    }

    @ParametersAreNonnullByDefault
    public boolean onUse(CompoundTag compound, ItemStack stack, Level world, Player player, InteractionHand hand, boolean shift) {
        return false;
    }

    public CompoundTag getTag(CompoundTag stackTag) {
        if (!stackTag.m_128441_(String.valueOf(this.id) + "_tag")) {
            stackTag.m_128365_(String.valueOf(this.id) + "_tag", (Tag)new CompoundTag());
        }
        return stackTag.m_128469_(String.valueOf(this.id) + "_tag");
    }

    @Nonnull
    public UniverseDialerMode next() {
        return this.next;
    }

    @Nonnull
    public UniverseDialerMode prev() {
        return this.prev;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String localize() {
        return I18n.format(this.title);
    }

    public static Optional<UniverseDialerMode> valueOf(ResourceLocation id) {
        return Optional.ofNullable(MODES.get(id));
    }

    public static UniverseDialerMode getDefault() {
        return firstMode;
    }

    public static Collection<UniverseDialerMode> values() {
        return MODES.values();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof UniverseDialerMode)) {
            return false;
        }
        UniverseDialerMode mode = (UniverseDialerMode)other;
        return Objects.equals(mode.id, this.id);
    }
}

